/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.impl.security.authentication.DescriptorHandler;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;

public class RunAsHandler
extends DescriptorHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    private static Log logger = LogFactory.getLog((String)RunAsHandler.class.getName());

    public void handle(MessageContext msgCtx, ResourceSecurityDescriptor resDesc, ServiceSecurityDescriptor desc, String servicePath) throws AxisFault {
        int runAsType = -1;
        Subject invocationSubject = null;
        QName opName = null;
        if (resDesc != null || desc != null) {
            try {
                opName = AuthUtil.getOperationName(msgCtx);
            }
            catch (SecurityException exp) {
                throw AxisFault.makeFault((Exception)exp);
            }
            if (resDesc != null && (runAsType = resDesc.getRunAsType(opName)) == -1) {
                runAsType = resDesc.getDefaultRunAsType();
            }
            if (runAsType == -1 && desc != null && (runAsType = desc.getRunAsType(opName)) == -1) {
                runAsType = desc.getDefaultRunAsType();
            }
        } else {
            runAsType = 2;
        }
        if (runAsType == -1) {
            runAsType = 4;
        }
        logger.debug((Object)("Run as for " + opName + " is " + runAsType));
        SecurityManager manager = SecurityManager.getManager((SOAPMessageContext)msgCtx);
        switch (runAsType) {
            case 1: {
                invocationSubject = (Subject)msgCtx.getProperty("callerSubject");
                break;
            }
            case 2: {
                try {
                    invocationSubject = manager.getSystemSubject();
                    break;
                }
                catch (Exception e) {
                    throw AxisFault.makeFault((Exception)e);
                }
            }
            case 3: {
                try {
                    invocationSubject = manager.getServiceSubject(servicePath);
                    break;
                }
                catch (Exception e) {
                    throw AxisFault.makeFault((Exception)e);
                }
            }
            case 4: {
                try {
                    Resource resource = null;
                    try {
                        ResourceContext context = ResourceContext.getResourceContext((SOAPMessageContext)msgCtx);
                        resource = context.getResource();
                    }
                    catch (ResourceContextException exp) {
                        logger.debug((Object)"Resource does not exist ", (Throwable)exp);
                        resource = null;
                    }
                    catch (ResourceException exp) {
                        logger.debug((Object)"Resource does not exist ", (Throwable)exp);
                        resource = null;
                    }
                    invocationSubject = manager.getSubject(servicePath, resource);
                    break;
                }
                catch (Exception e) {
                    throw AxisFault.makeFault((Exception)e);
                }
            }
            default: {
                throw new AxisFault(i18n.getMessage("badRunAs", (Object)String.valueOf(runAsType)));
            }
        }
        if (invocationSubject != null) {
            msgCtx.setProperty("invocationSubject", (Object)invocationSubject);
        } else {
            logger.debug((Object)"No invocation subject");
        }
    }
}

