/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.utils.XMLUtils;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.descriptor.AuthMethodParser;
import org.globus.wsrf.impl.security.descriptor.AuthMethodParserCallback;
import org.globus.wsrf.impl.security.descriptor.RunAsParser;
import org.globus.wsrf.impl.security.descriptor.RunAsParserCallback;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.util.ElementParser;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MethodParser
extends ElementParser
implements RunAsParserCallback,
AuthMethodParserCallback {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    public static final QName QNAME = new QName("http://www.globus.org", "method");
    protected ServiceSecurityDescriptor descriptor;
    protected QName method;

    public MethodParser(ServiceSecurityDescriptor descriptor) {
        super(QNAME);
        this.descriptor = descriptor;
        this.register(RunAsParser.QNAME, new RunAsParser(this));
        this.register(AuthMethodParser.QNAME, new AuthMethodParser(this));
    }

    public void parse(Element element) throws ElementParserException {
        String methodName = element.getAttribute("name");
        if (methodName == null || methodName.length() == 0) {
            throw new SecurityDescriptorException(i18n.getMessage("missingMethod"));
        }
        this.method = XMLUtils.getQNameFromString((String)methodName, (Node)element);
        if (this.method == null) {
            throw new SecurityDescriptorException(i18n.getMessage("invalidMethod"));
        }
        super.parse(element);
    }

    public void setRunAsType(int identity) throws SecurityDescriptorException {
        this.descriptor.setMethodRunAsType(this.method, identity);
    }

    public void setAuthMethods(List methods) throws SecurityDescriptorException {
        this.descriptor.setMethodAuthMethods(this.method, methods);
    }
}

