/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container.usage;

import org.globus.usage.packets.CustomByteBuffer;
import org.globus.wsrf.container.usage.ContainerUsageBasePacket;

public class ContainerUsageStartPacket
extends ContainerUsageBasePacket {
    public static final short START_EVENT = 1;
    private String list;

    public ContainerUsageStartPacket() {
        super((short)1);
    }

    public void setServiceList(String list) {
        this.list = list;
    }

    public String getServiceList() {
        return this.list;
    }

    public void packCustomFields(CustomByteBuffer buf) {
        super.packCustomFields(buf);
        byte[] data = this.list.getBytes();
        buf.putShort((short)data.length);
        int maxLen = Math.min(data.length, buf.remaining());
        buf.put(data, 0, maxLen);
    }

    public void unpackCustomFields(CustomByteBuffer buf) {
        super.unpackCustomFields(buf);
        short len = buf.getShort();
        int maxLen = Math.min(len, buf.remaining());
        byte[] data = new byte[maxLen];
        buf.get(data);
        this.list = new String(data);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(", services: " + this.getServiceList());
        return buf.toString();
    }
}

