/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.client.eximpl;

import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISInputStream;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.impl.AbstractClient;
import org.gcube.common.core.informationsystem.client.impl.AbstractQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.informationsystem.client.eximpl.ExistClientUtil;
import org.gcube.common.informationsystem.client.eximpl.ExistQuery;
import org.gcube.common.informationsystem.client.eximpl.ISInputStreamImpl;
import org.gcube.common.informationsystem.client.eximpl.queries.GCUBEGenericQueryImpl;
import org.gcube.informationsystem.collector.stubs.XQueryAccessPortType;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteRequest;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteResponse;
import org.gcube.informationsystem.collector.stubs.XQueryFaultType;
import org.gcube.informationsystem.collector.stubs.service.XQueryAccessServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistClient
extends AbstractClient {
    private <RESULT> List<RESULT> _execute(ISQuery<RESULT> iSQuery, GCUBEScope gCUBEScope) throws ISException {
        XQueryExecuteResponse xQueryExecuteResponse;
        ExistQuery existQuery = (ExistQuery)iSQuery;
        ArrayList arrayList = new ArrayList();
        this.checkQuery(iSQuery);
        XQueryAccessPortType xQueryAccessPortType = null;
        try {
            xQueryExecuteResponse = existQuery.getISICEPRs(gCUBEScope);
            String string = xQueryExecuteResponse.iterator().next().getAddress().toString();
            this.logger.trace((Object)("Submitting the query to " + string));
            xQueryAccessPortType = new XQueryAccessServiceLocator().getXQueryAccessPortTypePort(new URL(string));
            xQueryAccessPortType = (XQueryAccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)xQueryAccessPortType, (GCUBEScope)gCUBEScope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception exception) {
            this.logger.error((Object)("Error while creating portType for query submission, the query was \n" + iSQuery.getExpression()), (Throwable)exception);
            throw new ISException(exception);
        }
        xQueryExecuteResponse = null;
        long l = 0L;
        try {
            l = System.currentTimeMillis();
            String string = existQuery.getExpression();
            if (gCUBEScope.getType().compareTo((Enum)GCUBEScope.Type.VRE) == 0) {
                string = ExistClientUtil.queryAddAuthenticationControl(string, gCUBEScope.toString());
            }
            this.logger.debug((Object)("Query to submit: " + string));
            XQueryExecuteRequest xQueryExecuteRequest = new XQueryExecuteRequest();
            xQueryExecuteRequest.setXQueryExpression(string);
            xQueryExecuteResponse = xQueryAccessPortType.XQueryExecute(xQueryExecuteRequest);
        }
        catch (XQueryFaultType xQueryFaultType) {
            this.logger.error((Object)"XQuery Fault received", (Throwable)xQueryFaultType);
            throw new ISException((Exception)((Object)xQueryFaultType));
        }
        catch (Exception exception) {
            this.logger.error((Object)("Error while executing the XQuery " + iSQuery.getExpression()));
            throw new ISException(exception);
        }
        long l2 = System.currentTimeMillis();
        this.logger.trace((Object)("Query took " + (l2 - l) + " ms"));
        if (xQueryExecuteResponse == null) {
            this.logger.error((Object)"Invalid response received from the IC instance");
            throw new ISException("Invalid response received from the IC instance");
        }
        this.logger.debug((Object)("Number of returned records: " + xQueryExecuteResponse.getSize()));
        if (xQueryExecuteResponse.getSize() == 0L) {
            return arrayList;
        }
        try {
            Pattern pattern = Pattern.compile("<Record>(.*?)</Record>", 32);
            Matcher matcher = pattern.matcher(xQueryExecuteResponse.getDataset());
            while (matcher.find()) {
                try {
                    arrayList.add(existQuery.parseResult(matcher.group(1)));
                }
                catch (ISClient.ISMalformedResultException iSMalformedResultException) {
                    this.logger.warn((Object)"malformed profile found");
                }
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"ISclient: Error while parsing XQuery result\n");
            throw new ISClient.ISMalformedResultException(exception);
        }
        return arrayList;
    }

    protected void loadQueries(Map<Class<? extends ISQuery<?>>, Class<? extends ISQuery<?>>> map) {
        try {
            Properties properties = new Properties();
            properties.load(ExistClient.class.getResourceAsStream("QueryImpl.properties"));
            for (Object object : properties.keySet()) {
                map.put(Class.forName((String)object), Class.forName((String)properties.get(object)));
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"Could not load query implementation", (Throwable)exception);
        }
    }

    protected void loadGenericQueries(Map<String, String> map) {
        try {
            Properties properties = new Properties();
            properties.load(ExistClient.class.getResourceAsStream("GenericQueries.properties"));
            for (Object object : properties.keySet()) {
                map.put((String)object, (String)properties.get(object));
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"Could not load query implementation", (Throwable)exception);
        }
    }

    public GCUBEGenericQuery getQuery(String string) throws ISClient.ISUnsupportedQueryException {
        GCUBEGenericQueryImpl gCUBEGenericQueryImpl = new GCUBEGenericQueryImpl();
        String string2 = (String)genericQueries.get(string);
        if (string2 == null) {
            throw new ISClient.ISUnsupportedQueryException();
        }
        gCUBEGenericQueryImpl.setExpression("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';\ndeclare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';\n" + string2);
        return gCUBEGenericQueryImpl;
    }

    protected Class<? extends AbstractQuery> getQueryBaseClass() {
        return ExistQuery.class;
    }

    public <RESULT> ISInputStream<RESULT> executeByRef(ISQuery<RESULT> iSQuery, GCUBEScope gCUBEScope) throws ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException {
        return new ISInputStreamImpl<RESULT>(this._execute(iSQuery, gCUBEScope));
    }

    public <RESULT> List<RESULT> execute(ISQuery<RESULT> iSQuery, GCUBEScope gCUBEScope) throws ISClient.ISUnsupportedQueryException, ISException {
        return this._execute(iSQuery, gCUBEScope);
    }

    public <RESULT> List<RESULT> execute(ISQuery<RESULT> iSQuery) throws ISClient.ISUnsupportedQueryException, ISException {
        return this._execute(iSQuery, GCUBEScopeManager.DEFAULT.getScope());
    }
}

