/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.ObjectFieldDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectField
extends Field {
    private IPumpable payload = null;
    private boolean marshaledCompleted = false;

    public ObjectField() {
    }

    public ObjectField(IPumpable payload) {
        this.payload = payload;
    }

    public void setPayload(IPumpable payload) {
        this.payload = payload;
    }

    public IPumpable getPayload() {
        return this.payload;
    }

    @Override
    public ObjectFieldDefinition getFieldDefinition() throws GRS2RecordDefinitionException {
        if (!(super.getFieldDefinition() instanceof ObjectFieldDefinition)) {
            throw new GRS2RecordDefinitionException("Provided field definition is not of required type");
        }
        return (ObjectFieldDefinition)super.getFieldDefinition();
    }

    @Override
    public boolean isAvailable() {
        return this.marshaledCompleted || !this.isRemoteCopy();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        byte[] br;
        if (this.payload == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            this.payload.deflate(dout);
            try {
                dout.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bout.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            br = bout.toByteArray();
        }
        catch (GRS2RecordSerializationException e) {
            throw new IOException("Unable to deflate object : " + e.getMessage());
        }
        return new ByteArrayInputStream(br);
    }

    @Override
    public void extendSend(DataOutput out, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        try {
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("More to marshal requested but full payload is already provided");
            }
            this.record.markActivity();
            if (this.payload == null) {
                this.marshaledCompleted = true;
                out.writeBoolean(false);
            } else {
                if (dir == IBuffer.TransportDirective.Inherit) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
                }
                if (dir == IBuffer.TransportDirective.Partial) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
                }
                out.writeBoolean(true);
                out.writeUTF(this.payload.getClass().getName());
                this.payload.deflate(out);
                this.marshaledCompleted = true;
                this.record.markActivity();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal field", e);
        }
    }

    @Override
    public void extendReceive(DataInput in, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        try {
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("Marshaling of field is already completed");
            }
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (dir == IBuffer.TransportDirective.Inherit) {
                throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
            }
            this.record.markActivity();
            boolean payloadNotNull = in.readBoolean();
            if (!payloadNotNull) {
                this.payload = null;
                this.marshaledCompleted = true;
            } else {
                String pumpableType = in.readUTF();
                this.payload = (IPumpable)Class.forName(pumpableType).newInstance();
                this.payload.inflate(in);
                this.marshaledCompleted = true;
                this.record.markActivity();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to unmarshal field", e);
        }
    }

    @Override
    public void extendDispose() {
        this.payload = null;
        this.marshaledCompleted = false;
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            if (this.payload == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.payload.getClass().getName());
                this.payload.deflate(out);
            }
            out.writeBoolean(this.marshaledCompleted);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("unable to deflate field", ex);
        }
    }

    @Override
    public void extendToXML(Document doc, Element element) throws GRS2RecordSerializationException {
        try {
            Element el = null;
            Element elm = null;
            if (this.payload != null) {
                el = doc.createElement("payloadElement");
                elm = doc.createElement("payloadClassName");
                elm.setTextContent(String.valueOf(this.payload.getClass().getName()));
                el.appendChild(elm);
                Element payload = this.payload.toXML(doc);
                el.appendChild(payload);
                element.appendChild(el);
            }
            elm = doc.createElement("marshaledCompleted");
            elm.setTextContent(String.valueOf(this.marshaledCompleted));
            element.appendChild(elm);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to deflate field", e);
        }
    }

    @Override
    public void extendFromXML(Element element, boolean reset) throws GRS2RecordSerializationException {
        Element payloadElement = (Element)element.getElementsByTagName("payloadElement").item(0);
        String payloadClassName = payloadElement.getElementsByTagName("payloadClassName").item(0).getTextContent();
        try {
            this.payload = (IPumpable)Class.forName(payloadClassName).newInstance();
            this.marshaledCompleted = Boolean.valueOf(element.getElementsByTagName("marshaledCompleted").item(0).getTextContent());
            if (reset) {
                this.marshaledCompleted = false;
            }
            this.payload.fromXML(payloadElement);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to get record from xml", e);
        }
    }

    @Override
    public void extendInflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            boolean payloadNotNull = in.readBoolean();
            if (!payloadNotNull) {
                this.payload = null;
            } else {
                String pumpableType = in.readUTF();
                this.payload = (IPumpable)Class.forName(pumpableType).newInstance();
                this.payload.inflate(in);
            }
            this.marshaledCompleted = in.readBoolean();
            if (reset) {
                this.marshaledCompleted = false;
            }
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("unable to inflate field", ex);
        }
    }

    @Override
    protected void extendMakeLocal() {
        this.marshaledCompleted = false;
    }

    @Override
    public void extendSendToXML(Document doc, Element element, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        try {
            Element el = null;
            Element elm = null;
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("More to marshal requested but full payload is already provided");
            }
            this.record.markActivity();
            if (this.payload == null) {
                this.marshaledCompleted = true;
            } else {
                if (dir == IBuffer.TransportDirective.Inherit) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
                }
                if (dir == IBuffer.TransportDirective.Partial) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
                }
                el = doc.createElement("payloadElement");
                elm = doc.createElement("payloadClassName");
                elm.setTextContent(String.valueOf(this.payload.getClass().getName()));
                el.appendChild(elm);
                Element payload = this.payload.toXML(doc);
                el.appendChild(payload);
                element.appendChild(el);
                this.marshaledCompleted = true;
                this.record.markActivity();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal field", e);
        }
    }

    @Override
    public void extendReceiveFromXML(Element element, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        try {
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("Marshaling of field is already completed");
            }
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (dir == IBuffer.TransportDirective.Inherit) {
                throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
            }
            this.record.markActivity();
            Element payloadElement = (Element)element.getElementsByTagName("payloadElement").item(0);
            if (payloadElement != null) {
                String payloadClassName = payloadElement.getElementsByTagName("payloadClassName").item(0).getTextContent();
                this.payload = (IPumpable)Class.forName(payloadClassName).newInstance();
                this.payload.fromXML(payloadElement);
                this.marshaledCompleted = true;
                this.record.markActivity();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to unmarshal field", e);
        }
    }
}

