/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.event;

import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.store.event.GRS2EventStoreAccessException;
import gr.uoa.di.madgik.grs.store.event.GRS2EventStoreException;
import gr.uoa.di.madgik.grs.store.event.IEventStore;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.UUID;

public class FileEventStore
implements IEventStore {
    private File eventFile = File.createTempFile(UUID.randomUUID().toString(), null);
    private RandomAccessFile rand = null;
    private Hashtable<Long, Long> mappingOrdered = null;
    private long eventCount = 0L;

    public FileEventStore() throws IOException {
        this.eventFile.deleteOnExit();
        this.rand = new RandomAccessFile(this.eventFile, "rw");
        this.mappingOrdered = new Hashtable();
        this.eventCount = 0L;
    }

    @Override
    public long getEventCount() {
        return this.eventCount;
    }

    @Override
    public synchronized void dispose() throws GRS2EventStoreException {
        try {
            if (this.mappingOrdered != null) {
                this.mappingOrdered.clear();
                this.mappingOrdered = null;
            }
            this.rand.close();
            this.eventFile.delete();
        }
        catch (Exception e) {
            throw new GRS2EventStoreException("Could not dispose persistency manager resources", e);
        }
    }

    @Override
    public synchronized void persist(BufferEvent event) throws GRS2EventStoreException {
        try {
            this.rand.seek(this.rand.length());
            long offset = this.rand.getFilePointer();
            this.rand.writeUTF(event.getClass().getName());
            event.deflate(this.rand);
            this.mappingOrdered.put(this.eventCount, offset);
            ++this.eventCount;
        }
        catch (Exception e) {
            throw new GRS2EventStoreAccessException("Could not persist event", e);
        }
    }

    @Override
    public synchronized BufferEvent retrieveByIndex(long eventIndex) throws GRS2EventStoreException {
        try {
            if (!this.mappingOrdered.containsKey(eventIndex)) {
                return null;
            }
            this.rand.seek(this.mappingOrdered.get(eventIndex));
            String eventType = this.rand.readUTF();
            BufferEvent event = (BufferEvent)Class.forName(eventType).newInstance();
            event.inflate(this.rand);
            return event;
        }
        catch (Exception e) {
            throw new GRS2EventStoreAccessException("Could not retrieve event", e);
        }
    }
}

