/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.record;

import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.store.record.GRS2RecordStoreAccessException;
import gr.uoa.di.madgik.grs.store.record.GRS2RecordStoreException;
import gr.uoa.di.madgik.grs.store.record.IRecordStore;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.UUID;

public class FileRecordStore
implements IRecordStore {
    private File recordFile = File.createTempFile(UUID.randomUUID().toString(), null);
    private RandomAccessFile rand = null;
    private Hashtable<Long, Long> mappingSimple = null;
    private Hashtable<Long, Long> mappingOrdered = null;
    private boolean enableOrder = false;
    private long recordCount = 0L;

    public FileRecordStore() throws IOException {
        this.recordFile.deleteOnExit();
        this.rand = new RandomAccessFile(this.recordFile, "rw");
        this.mappingSimple = new Hashtable();
        if (this.enableOrder) {
            this.mappingOrdered = new Hashtable();
        }
        this.recordCount = 0L;
    }

    @Override
    public void enableOrder(boolean enableOrder) {
        this.enableOrder = enableOrder;
        this.mappingOrdered = this.enableOrder ? new Hashtable() : null;
    }

    @Override
    public long getRecordCount() {
        return this.recordCount;
    }

    @Override
    public synchronized void dispose() throws GRS2RecordStoreException {
        try {
            if (this.mappingSimple != null) {
                this.mappingSimple.clear();
                this.mappingSimple = null;
            }
            if (this.mappingOrdered != null) {
                this.mappingOrdered.clear();
                this.mappingOrdered = null;
            }
            this.rand.close();
            this.recordFile.delete();
        }
        catch (Exception e) {
            throw new GRS2RecordStoreException("Could not dispose persistency manager resources", e);
        }
    }

    @Override
    public synchronized void persist(Record record) throws GRS2RecordStoreException {
        try {
            if (this.mappingSimple.containsKey(record.getID())) {
                return;
            }
            this.rand.seek(this.rand.length());
            long offset = this.rand.getFilePointer();
            this.rand.writeUTF(record.getClass().getName());
            record.deflate(this.rand);
            this.mappingSimple.put(record.getID(), offset);
            if (this.enableOrder) {
                this.mappingOrdered.put(this.recordCount, record.getID());
            }
            ++this.recordCount;
        }
        catch (Exception e) {
            throw new GRS2RecordStoreAccessException("Could not persist record", e);
        }
    }

    @Override
    public synchronized Record retrieve(long recordID, boolean reset) throws GRS2RecordStoreException {
        try {
            if (!this.mappingSimple.containsKey(recordID)) {
                return null;
            }
            this.rand.seek(this.mappingSimple.get(recordID));
            String recordType = this.rand.readUTF();
            Record record = (Record)Class.forName(recordType).newInstance();
            record.inflate(this.rand, reset);
            return record;
        }
        catch (Exception e) {
            throw new GRS2RecordStoreAccessException("Could not retrieve record", e);
        }
    }

    @Override
    public synchronized Record retrieveByIndex(long recordIndex, boolean reset) throws GRS2RecordStoreException {
        try {
            if (!this.enableOrder) {
                throw new GRS2RecordStoreAccessException("this operation is only available when ordering is enabled");
            }
            if (!this.mappingOrdered.containsKey(recordIndex)) {
                return null;
            }
            return this.retrieve(this.mappingOrdered.get(recordIndex), reset);
        }
        catch (Exception e) {
            throw new GRS2RecordStoreAccessException("Could not persist record", e);
        }
    }
}

