/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.instancestates.BaseInstanceStateHandler;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RegisterInstanceStatePullHandler;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RegisterInstanceStatePushHandler;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RegistrationPoolExecutor;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RemoveInstanceStateHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.ISPublisherHandler;

public final class InstanceStatePublisher {
    private static Map<String, ISPublisherHandler> activeRegistrationsQueue = Collections.synchronizedMap(new HashMap());
    private static final GCUBELog logger = new GCUBELog(InstanceStatePublisher.class);
    private GCUBEScope publishingScope;

    public InstanceStatePublisher(GCUBEScope scope) throws GCUBEPublisherException {
        this.publishingScope = scope;
    }

    public void register(GCUBEWSResource resource, String ... name) throws GCUBEPublisherException {
        BaseInstanceStateHandler handler;
        String mode = resource.getPorttypeContext().getPublicationProfile().getMode();
        if (mode.equalsIgnoreCase("pull")) {
            try {
                logger.debug((Object)("Pull mode detected for " + ((GCUBEWSResourceKey)resource.getID()).toString()));
                handler = new RegisterInstanceStatePullHandler(resource, this.publishingScope, mode, name);
                handler.register();
            }
            catch (Exception e) {
                logger.error((Object)("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)resource.getID()).toString()), (Throwable)e);
                throw new GCUBEPublisherException("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)resource.getID()).toString());
            }
        } else if (mode.equalsIgnoreCase("push")) {
            logger.debug((Object)("Push mode detected for " + ((GCUBEWSResourceKey)resource.getID()).toString()));
            try {
                handler = new RegisterInstanceStatePushHandler(resource, this.publishingScope, mode, name);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)resource.getID()).toString()), (Throwable)e);
                throw new GCUBEPublisherException("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)resource.getID()).toString());
            }
        } else {
            logger.debug((Object)("Invalid " + mode + " mode detected for " + ((GCUBEWSResourceKey)resource.getID()).toString()));
            throw new GCUBEPublisherException("Invalid publication mode " + mode);
        }
        try {
            String key = this.makeActivationKey(resource, handler);
            if (activeRegistrationsQueue.containsKey(key) && activeRegistrationsQueue.get(key).getFutureTask() != null) {
                logger.warn((Object)("A previous task was already activated for resource " + handler.getResourceID()));
            } else {
                logger.debug((Object)("Scheduling a new task for resource " + handler.getResourceID()));
                Future<?> future = RegistrationPoolExecutor.getExecutor().submit(handler);
                handler.setFutureTask(future);
                activeRegistrationsQueue.put(key, handler);
            }
        }
        catch (Exception e) {
            throw new GCUBEPublisherException(e.getMessage());
        }
    }

    public void remove(GCUBEWSResource resource, String ... name) throws GCUBEPublisherException {
        try {
            RemoveInstanceStateHandler handler = new RemoveInstanceStateHandler(resource, this.publishingScope, name);
            String key = this.makeActivationKey(resource, handler);
            ISPublisherHandler registrationHandler = activeRegistrationsQueue.get(key);
            if (registrationHandler.getFutureTask() != null && !registrationHandler.getFutureTask().cancel(true)) {
                logger.warn((Object)("Unable to cancel the registration handler for " + registrationHandler.getResourceID()));
            }
            activeRegistrationsQueue.remove(key);
            handler.execute();
        }
        catch (Exception e) {
            logger.warn((Object)("could not complete the unregistration of " + resource.getClass().getSimpleName() + "(" + resource.getID() + ")"), (Throwable)e);
            throw new GCUBEPublisherException("could not complete the unregistration of " + resource.getClass().getSimpleName() + "(" + resource.getID() + ")", e);
        }
    }

    private String makeActivationKey(GCUBEWSResource resource, ISPublisherHandler handler) throws Exception {
        return resource.getEPR().getAddress().toString() + handler.getResourceID() + this.publishingScope;
    }
}

