/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.security.Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.glite.security.util.DN;
import sun.security.x509.X500Name;

public class DNImpl
implements DN {
    public static final int RFC2253 = 0;
    public static final int X500 = 1;
    public static final int CANON = 2;
    static Logger logger = Logger.getLogger((String)DNImpl.class.getName());
    public String rfc2253String = null;
    public String x500String = null;
    public String canonicalString = null;
    public String[] rdns = null;
    public DERObjectIdentifier[] oids = null;
    public int count = 0;

    public DNImpl(DERObjectIdentifier[] newOids, String[] newRdns, int newCount) {
        this.oids = newOids;
        this.rdns = newRdns;
        this.count = newCount;
    }

    public DNImpl(String name) {
        if (name.startsWith("/")) {
            throw new IllegalArgumentException("input is in X500 format, RCF2253 format was expected. The input was: " + name);
        }
        this.parse(name);
    }

    public DNImpl(Principal principal) {
        X509Principal x509Principal;
        if (principal instanceof X509Principal) {
            logger.debug((Object)"input is X509Principal");
            x509Principal = (X509Principal)principal;
        } else if (principal instanceof X500Name) {
            logger.debug((Object)"input is java Principal");
            try {
                x509Principal = new X509Principal(((X500Name)principal).getEncoded());
            }
            catch (Exception e) {
                logger.error((Object)("Invalid X500Principal DN name: " + (X500Name)principal));
                throw new IllegalArgumentException("Invalid X500Principal DN name: " + (X500Name)principal);
            }
        } else {
            logger.debug((Object)("input is some other principal: " + principal.getClass().getName()));
            x509Principal = new X509Principal(true, principal.getName());
        }
        this.oids = x509Principal.getOIDs().toArray(new DERObjectIdentifier[0]);
        this.rdns = x509Principal.getValues().toArray(new String[0]);
        this.count = this.oids.length;
    }

    public String getX500() {
        if (this.x500String == null) {
            this.constructX500();
        }
        return this.x500String;
    }

    public String getRFC2253() {
        if (this.rfc2253String == null) {
            this.constructRFC2253(false);
        }
        return this.rfc2253String;
    }

    public String getCanon() {
        if (this.canonicalString == null) {
            this.constructRFC2253(true);
        }
        return this.canonicalString;
    }

    public String constructX500() {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < this.count; ++n) {
            buf.append('/');
            buf.append((String)X509Name.DefaultSymbols.get(this.oids[n]));
            buf.append('=');
            buf.append(this.rdns[n]);
        }
        this.x500String = buf.toString();
        return this.x500String;
    }

    public String constructRFC2253(boolean canon) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (int n = 0; n < this.count; ++n) {
            if (!first) {
                buf.append(',');
            }
            first = false;
            buf.append((String)X509Name.DefaultSymbols.get(this.oids[n]));
            buf.append('=');
            buf.append(this.rdns[n]);
        }
        this.rfc2253String = buf.toString();
        this.canonicalString = buf.toString().toLowerCase();
        if (canon) {
            return this.canonicalString;
        }
        return this.rfc2253String;
    }

    public void parse(String inputDN) {
        X509Principal x509Principal = new X509Principal(false, inputDN);
        this.oids = x509Principal.getOIDs().toArray(new DERObjectIdentifier[0]);
        this.rdns = x509Principal.getValues().toArray(new String[0]);
        this.count = this.oids.length;
    }

    public boolean equals(Object inputDN2) {
        if (inputDN2 instanceof DNImpl) {
            int n;
            DNImpl dn2 = (DNImpl)inputDN2;
            if (this.count != dn2.count) {
                return false;
            }
            for (n = 0; n < this.count; ++n) {
                if (this.oids[n].equals((Object)dn2.oids[n])) continue;
                return false;
            }
            for (n = 0; n < this.count; ++n) {
                if (this.rdns[n].toLowerCase().equals(dn2.rdns[n].toLowerCase())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getRFC2253();
    }

    public DN withoutLastCN(boolean checkProxy) {
        if (!this.oids[this.count - 1].equals((Object)X509Name.CN)) {
            throw new IllegalArgumentException("Trying to remove last CN from DN that does not end in CN. DN was: " + this.toString());
        }
        if (checkProxy && !this.rdns[this.count - 1].matches("^((limited )*proxy|[0-9]*)$")) {
            throw new IllegalArgumentException("Trying to remove the last proxy CN from DN that does not end in proxy CN. DN was: " + this.toString());
        }
        int newCount = this.count - 1;
        String[] newRdns = new String[newCount];
        DERObjectIdentifier[] newOids = new DERObjectIdentifier[newCount];
        for (int n = 0; n < newCount; ++n) {
            newRdns[n] = this.rdns[n];
            newOids[n] = this.oids[n];
        }
        return new DNImpl(newOids, newRdns, newCount);
    }

    public int hashCode() {
        return this.rdns.hashCode() + this.oids.hashCode() + this.count;
    }
}

