/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.endpoint.util.WhitespaceSkipper;
import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import java.util.List;
import java.util.Map;

public class JsonTranscoder
extends AbstractTranscoder<JsonDocument, JsonObject> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(JsonTranscoder.class);

    @Override
    public Class<JsonDocument> documentType() {
        return JsonDocument.class;
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(JsonDocument document) throws Exception {
        return Tuple.create((Object)this.jsonObjectToByteBuf((JsonObject)document.content()), (Object)TranscoderUtils.JSON_COMPAT_FLAGS);
    }

    @Override
    protected JsonDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        if (!TranscoderUtils.hasJsonFlags(flags)) {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non-JSON document for " + "id " + id + ", could not decode.");
        }
        return this.newDocument(id, expiry, this.byteBufToJsonObject(content), cas);
    }

    @Override
    public JsonDocument newDocument(String id, int expiry, JsonObject content, long cas) {
        return JsonDocument.create(id, expiry, content, cas);
    }

    @Override
    public JsonDocument newDocument(String id, int expiry, JsonObject content, long cas, MutationToken mutationToken) {
        return JsonDocument.create(id, expiry, content, cas, mutationToken);
    }

    public String jsonObjectToString(JsonObject input) throws Exception {
        return JacksonTransformers.MAPPER.writeValueAsString((Object)input);
    }

    public ByteBuf jsonObjectToByteBuf(JsonObject input) throws Exception {
        return Unpooled.wrappedBuffer((byte[])JacksonTransformers.MAPPER.writeValueAsBytes((Object)input));
    }

    public JsonObject stringToJsonObject(String input) throws Exception {
        return (JsonObject)JacksonTransformers.MAPPER.readValue(input, JsonObject.class);
    }

    private <T> T byteBufToClass(ByteBuf input, Class<? extends T> clazz) throws Exception {
        byte[] inputBytes;
        int offset = 0;
        int length = input.readableBytes();
        if (input.hasArray()) {
            inputBytes = input.array();
            offset = input.arrayOffset() + input.readerIndex();
        } else {
            inputBytes = new byte[length];
            input.getBytes(input.readerIndex(), inputBytes);
        }
        return (T)JacksonTransformers.MAPPER.readValue(inputBytes, offset, length, clazz);
    }

    public JsonObject byteBufToJsonObject(ByteBuf input) throws Exception {
        return this.byteBufToClass(input, JsonObject.class);
    }

    public Object byteBufJsonValueToObject(ByteBuf input) throws Exception {
        int toSkip = input.forEachByte((ByteBufProcessor)new WhitespaceSkipper());
        if (toSkip > 0) {
            input.skipBytes(toSkip);
        }
        input.markReaderIndex();
        byte first = input.readByte();
        input.resetReaderIndex();
        switch (first) {
            case 123: {
                return this.byteBufToJsonObject(input);
            }
            case 91: {
                return this.byteBufToClass(input, JsonArray.class);
            }
        }
        Object value = this.byteBufToClass(input, Object.class);
        if (value instanceof Map) {
            LOGGER.warn("A JSON object could not be fast detected (first byte '" + (char)first + "')");
            return JsonObject.from((Map)value);
        }
        if (value instanceof List) {
            LOGGER.warn("A JSON array could not be fast detected (first byte '" + (char)first + "')");
            return JsonArray.from((List)value);
        }
        return value;
    }
}

