/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Buffer;
import org.globus.ftp.dc.DataChannelWriter;
import org.globus.ftp.dc.EBlockAware;
import org.globus.ftp.dc.EBlockParallelTransferContext;

public class EBlockImageDCWriter
extends EBlockAware
implements DataChannelWriter {
    static Log logger = LogFactory.getLog((class$org$globus$ftp$dc$EBlockImageDCWriter == null ? (class$org$globus$ftp$dc$EBlockImageDCWriter = EBlockImageDCWriter.class$("org.globus.ftp.dc.EBlockImageDCWriter")) : class$org$globus$ftp$dc$EBlockImageDCWriter).getName());
    protected DataOutputStream output;
    static /* synthetic */ Class class$org$globus$ftp$dc$EBlockImageDCWriter;

    public void setDataStream(OutputStream out) {
        this.output = new DataOutputStream(out);
    }

    public void write(Buffer buf) throws IOException {
        long offset = buf.getOffset();
        if (offset < 0L) {
            throw new IOException("Invalid offset: " + offset);
        }
        this.output.writeByte(0);
        logger.debug("buffer length: " + buf.getLength());
        this.output.writeLong(buf.getLength());
        logger.debug("offset: " + offset);
        this.output.writeLong(offset);
        this.output.write(buf.getBuffer(), 0, buf.getLength());
        logger.debug("wrote the buffer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOfData() throws IOException {
        EBlockParallelTransferContext eBlockParallelTransferContext = this.context;
        synchronized (eBlockParallelTransferContext) {
            if (this.context.eodsTransferred == 0) {
                int desc = 72;
                this.output.writeByte(desc);
                this.output.writeLong(0L);
                this.output.writeLong(this.context.eodsTotal);
                logger.debug("wrote EOF (expected EODS: " + this.context.eodsTotal + ") and EOD");
            } else {
                int desc = 8;
                this.output.writeByte(desc);
                this.output.writeLong(0L);
                this.output.writeLong(0L);
                logger.debug("wrote EOD");
            }
            this.context.eodTransferred();
        }
        this.output.flush();
    }

    public static void close(DataOutputStream myOutput) throws IOException {
        int desc = 4;
        myOutput.writeByte(desc);
        myOutput.writeLong(0L);
        myOutput.writeLong(0L);
        logger.debug("Wrote WILL_CLOSE, closing the socket");
        myOutput.close();
    }

    public void close() throws IOException {
        EBlockImageDCWriter.close(this.output);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

