/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListener;
import org.globus.wsrf.impl.SimpleSubscriptionTopicListener;

public class SubscriptionPersistenceUtils {
    public static void storeSubscriptionListeners(TopicList topicList, ObjectOutputStream oos) throws IOException {
        Map topicListenerTable = SubscriptionPersistenceUtils.getListenerToTopicsTable(topicList);
        oos.writeObject(topicListenerTable);
    }

    public static Map getListenerToTopicsTable(TopicList topicList) {
        HashMap topicListenerTable = new HashMap();
        Iterator topicIterator = topicList.topicIterator();
        while (topicIterator.hasNext()) {
            SubscriptionPersistenceUtils.addSubscriptionListenersToTable((Topic)topicIterator.next(), topicListenerTable);
        }
        return topicListenerTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSubscriptionListenersToTable(Topic topic, Map topicListenerTable) {
        Topic topic2 = topic;
        synchronized (topic2) {
            Iterator topicListenerIterator = topic.topicListenerIterator();
            List topicPath = topic.getTopicPath();
            while (topicListenerIterator.hasNext()) {
                TopicListener listener = (TopicListener)topicListenerIterator.next();
                if (!(listener instanceof SimpleSubscriptionTopicListener)) continue;
                ArrayList<List> topics = (ArrayList<List>)topicListenerTable.get(listener);
                if (topics == null) {
                    topics = new ArrayList<List>();
                    topics.add(topicPath);
                    topicListenerTable.put(listener, topics);
                    continue;
                }
                topics.add(topicPath);
            }
        }
        Iterator topicIterator = topic.topicIterator();
        while (topicIterator.hasNext()) {
            Topic subTopic = (Topic)topicIterator.next();
            SubscriptionPersistenceUtils.addSubscriptionListenersToTable(subTopic, topicListenerTable);
        }
    }

    public static void loadSubscriptionListeners(TopicList topicList, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Map topicListenerTable = (Map)ois.readObject();
        Iterator topicListenerIterator = topicListenerTable.entrySet().iterator();
        while (topicListenerIterator.hasNext()) {
            Map.Entry tableEntry = topicListenerIterator.next();
            TopicListener listener = (TopicListener)tableEntry.getKey();
            Iterator topicIterator = ((List)tableEntry.getValue()).iterator();
            while (topicIterator.hasNext()) {
                Topic topic = topicList.getTopic((List)topicIterator.next());
                topic.addTopicListener(listener);
            }
        }
    }
}

