/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.helpers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Vector;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.ResultSet;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.HeaderRef;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultSetRef;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RecordParser;
import org.gcube.common.searchservice.searchlibrary.resultset.security.Mnemonic;

public class RSFileHelper {
    private static Logger log = Logger.getLogger(RSFileHelper.class);
    private static final Runtime s_runtime = Runtime.getRuntime();

    private static String hash(String key) {
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            try {
                hash += key.charAt(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.toString(hash);
    }

    public static String generateName(short type, String seed) throws Exception {
        try {
            File base = new File("/tmp/resultset/");
            if (!base.exists()) {
                boolean succeeded = base.mkdirs();
                Runtime.getRuntime().exec("chmod 0777 " + base.getAbsolutePath());
                if (!succeeded) {
                    log.error((Object)"Could not create base directory /tmp/resultset/ Throwing Exception");
                    throw new Exception("Could not create base directory /tmp/resultset/");
                }
            }
            String unique = null;
            unique = seed == null ? RSConstants.nextUUID() : seed;
            String subdir = RSFileHelper.hash(unique);
            File subBase = new File("/tmp/resultset/" + subdir);
            if (!subBase.exists()) {
                boolean succeeded = subBase.mkdirs();
                Runtime.getRuntime().exec("chmod 0777 " + subBase.getAbsolutePath());
                if (!succeeded && !subBase.exists()) {
                    log.error((Object)("Could not create subase directory /tmp/resultset/" + subdir + " Throwing Exception"));
                    throw new Exception("Could not create subase directory /tmp/resultset/" + subdir);
                }
            }
            String genbase = "/tmp/resultset/" + subdir + File.separatorChar;
            if (type == 0) {
                return genbase + unique + ".rs";
            }
            if (type == 1) {
                return genbase + unique + ".hrs";
            }
            if (type == 2) {
                return genbase + unique + ".prs";
            }
            log.error((Object)("Unrecognized type " + type + " Throwing Exception"));
            throw new Exception("Unrecognized type " + type);
        }
        catch (Exception e) {
            log.error((Object)"Could not create base directory /tmp/resultset/ Throwing Exception", (Throwable)e);
            throw new Exception("Could not create base directory /tmp/resultset/");
        }
    }

    public static String headToFlowControl(String head) {
        return head + ".df";
    }

    public static String headToFlowControlTmp(String head) {
        return head + ".df" + ".tmp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSConstants.CONTROLFLOW waitOnFlowNotification(String headname, long time) {
        File flag;
        File head = new File(headname);
        if (!head.exists()) {
            return RSConstants.CONTROLFLOW.STOP;
        }
        long startTime = Calendar.getInstance().getTimeInMillis();
        do {
            if (Calendar.getInstance().getTimeInMillis() - startTime >= time) {
                log.error((Object)"Maximum waiting ammount of time reached. Returning false");
                return RSConstants.CONTROLFLOW.TIMEOUT;
            }
            try {
                Object object = RSConstants.controlFlowOnIt;
                synchronized (object) {
                    RSConstants.controlFlowOnIt.wait(250L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!(flag = new File(RSFileHelper.headToFlowControl(headname))).exists());
        return RSConstants.CONTROLFLOW.MORE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyOnFlowCreation(String headname) {
        Object object = RSConstants.controlFlowOnIt;
        synchronized (object) {
            File flag = new File(RSFileHelper.headToFlowControl(headname));
            try {
                flag.delete();
            }
            catch (Exception e) {
                log.error((Object)("Could not delete flag file " + RSFileHelper.headToFlowControl(headname) + ". Continuing"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestFlowCreation(String headname) {
        Object object = RSConstants.controlFlowOnIt;
        synchronized (object) {
            try {
                File flag = new File(RSFileHelper.headToFlowControlTmp(headname));
                flag.createNewFile();
                flag.renameTo(new File(RSFileHelper.headToFlowControl(headname)));
                RSConstants.controlFlowOnIt.notifyAll();
            }
            catch (Exception e) {
                log.error((Object)("Could not create flag file " + RSFileHelper.headToFlowControl(headname) + ". Continuing"), (Throwable)e);
            }
        }
    }

    public static String publicToTmp(String pubName) throws Exception {
        try {
            return pubName + ".tmp";
        }
        catch (Exception e) {
            log.error((Object)("Could not transform public " + pubName + " to tmp. Throwing Exception"), (Throwable)e);
            throw new Exception("Could not transform public " + pubName + " to tmp");
        }
    }

    public static String tmpToPublic(String tmpName) throws Exception {
        try {
            return tmpName.substring(0, tmpName.lastIndexOf(".tmp"));
        }
        catch (Exception e) {
            log.error((Object)("Could not transform tmp " + tmpName + " to public. Throwing Exception"), (Throwable)e);
            throw new Exception("Could not transform tmp " + tmpName + " to public");
        }
    }

    public static String headerToContent(String headerName) throws Exception {
        try {
            String seed = headerName.substring(headerName.lastIndexOf(File.separatorChar) + Character.toString(File.separatorChar).length(), headerName.lastIndexOf(".hrs"));
            return RSFileHelper.generateName((short)0, seed);
        }
        catch (Exception e) {
            log.error((Object)("Could not transform header name " + headerName + " to content name. Throwing Exception"));
            throw new Exception("Could not transform header name " + headerName + " to content name");
        }
    }

    public static String contentToHeader(String contentName) throws Exception {
        try {
            String seed = contentName.substring(contentName.lastIndexOf(File.separatorChar) + Character.toString(File.separatorChar).length(), contentName.lastIndexOf(".rs"));
            return RSFileHelper.generateName((short)1, seed);
        }
        catch (Exception e) {
            log.error((Object)("Could not transform content name " + contentName + " to header name. Throwing Exception"));
            throw new Exception("Could not transform content name " + contentName + " to header name");
        }
    }

    public static void persistContent(String filename, Vector<String> results, int count, Mnemonic mne) throws Exception {
        FileOutputStream fw = null;
        CipherOutputStream ci = null;
        BufferedWriter bw = null;
        OutputStreamWriter out = null;
        log.trace((Object)("persistContent of vectors called with file " + filename));
        try {
            fw = new FileOutputStream(filename);
            if (mne != null) {
                ci = new CipherOutputStream(fw, mne.getCipher());
                out = new OutputStreamWriter(ci);
            } else {
                out = new OutputStreamWriter(fw);
            }
            bw = new BufferedWriter(out);
            bw.write("<Body>\n");
            if (results != null) {
                int copy = results.size();
                if (count >= 0) {
                    copy = count;
                }
                for (int i = 0; i < copy && i < results.size(); ++i) {
                    bw.write(results.get(i));
                    bw.write("\n");
                }
            }
            bw.write("</Body>\n");
            bw.close();
            bw = null;
            out.close();
            out = null;
            if (mne != null) {
                ci.close();
                ci = null;
            }
            fw.close();
            fw = null;
            File tmpFile = new File(RSFileHelper.publicToTmp(filename));
            tmpFile.renameTo(new File(filename));
        }
        catch (Exception e) {
            log.error((Object)("Could not persist content to file " + filename + ". Throwing Exception"), (Throwable)e);
            if (bw != null) {
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
            throw new Exception("Could not persist content to file " + filename);
        }
    }

    public static boolean forceConsistency(String filename) throws Exception {
        File pub = new File(filename);
        String tmp = RSFileHelper.publicToTmp(filename);
        File tmpFile = new File(tmp);
        boolean success = true;
        success = pub.renameTo(tmpFile) ? tmpFile.renameTo(pub) : false;
        log.debug((Object)("consistency forcing was successful : " + success));
        return success;
    }

    public static void persistContent(String filename, String inWrap, Mnemonic mne) throws Exception {
        log.trace((Object)("persistContent of wrap called with file " + filename + " and wrap " + inWrap));
        try {
            if (mne != null) {
                int i;
                log.info((Object)("Encrypting " + inWrap + " into " + filename));
                FileInputStream source = new FileInputStream(inWrap);
                FileOutputStream fw = new FileOutputStream(filename);
                CipherOutputStream ci = new CipherOutputStream(fw, mne.getCipher());
                byte[] b = new byte[1024];
                while ((i = source.read(b)) != -1) {
                    ci.write(b, 0, i);
                }
                source.close();
                ci.close();
                fw.close();
                File s = new File(inWrap);
                s.delete();
            } else {
                log.info((Object)("Not Encrypting " + inWrap + " into " + filename));
                File source = new File(inWrap);
                for (int retry = 0; !source.renameTo(new File(filename)) && retry < 5; ++retry) {
                    log.error((Object)"renaming failed, retrying");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not persist content to file " + filename + " from file " + inWrap + ". Throwing Exception"), (Throwable)e);
            throw new Exception("Could not persist content to file " + filename + " from file " + inWrap);
        }
    }

    public static void persistHeader(HeaderRef header) throws Exception {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("localFileName:" + header.getLocalName() + "\n");
            buf.append("isHead:" + header.getIsHead() + "\n");
            buf.append("next:" + header.getNext() + "\n");
            buf.append("previous:" + header.getPrev() + "\n");
            fw = new FileWriter(new File(RSFileHelper.publicToTmp(header.getLocalName())));
            bw = new BufferedWriter(fw);
            bw.write(buf.toString());
            bw.flush();
            bw.close();
            bw = null;
            fw.close();
            fw = null;
            File tmpFile = new File(RSFileHelper.publicToTmp(header.getLocalName()));
            tmpFile.renameTo(new File(header.getLocalName()));
        }
        catch (Exception e) {
            if (fw != null) {
                fw.close();
            }
            if (bw != null) {
                bw.close();
            }
            log.error((Object)"Could not persist header to file. Throwing Exception", (Throwable)e);
            throw new Exception("Could not persist header to file");
        }
    }

    public static HeaderRef populateHeader(String filename) throws Exception {
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            RSFileHelper.isReady(filename);
            String localFilename = null;
            String isHead = null;
            String nextLink = null;
            String previousLink = null;
            fr = new FileReader(new File(filename));
            br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null) {
                int index = line.indexOf(":");
                String key = line.substring(0, index);
                String value = line.substring(index + ":".length());
                if (key.equalsIgnoreCase("localFileName")) {
                    localFilename = value;
                } else if (key.equalsIgnoreCase("isHead")) {
                    isHead = value;
                } else if (key.equalsIgnoreCase("next")) {
                    nextLink = value;
                } else if (key.equalsIgnoreCase("previous")) {
                    previousLink = value;
                }
                line = br.readLine();
            }
            br.close();
            br = null;
            fr.close();
            fr = null;
            return new HeaderRef(isHead, localFilename, previousLink, nextLink);
        }
        catch (Exception e) {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
            log.error((Object)("Could not populate header from file " + filename + ". Throwing Exception"), (Throwable)e);
            throw new Exception("Could not populate header from file " + filename);
        }
    }

    public static void touchHeader(String filename) {
        long time = System.currentTimeMillis();
        log.debug((Object)("Touching file: " + filename + " last modified time: " + time));
        File file = new File(filename);
        file.setLastModified(time);
    }

    public static boolean waitForIt(String filename, boolean flowControl, String headname) {
        return RSFileHelper.waitForIt(filename, 300000L, flowControl, headname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForIt(String filename, long time, boolean flowControl, String headname) {
        if (RSFileHelper.isReady(filename)) {
            return true;
        }
        long startTime = Calendar.getInstance().getTimeInMillis();
        do {
            if (Calendar.getInstance().getTimeInMillis() - startTime >= time) {
                log.error((Object)"Maximum waiting ammount of time reached. Returning false");
                return false;
            }
            try {
                if (flowControl) {
                    RSFileHelper.requestFlowCreation(headname);
                }
                Object object = RSConstants.sleepOnIt;
                synchronized (object) {
                    RSConstants.sleepOnIt.wait(250L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!RSFileHelper.isReady(filename));
        return true;
    }

    public static boolean isReady(String filename) {
        try {
            File tmp = new File(filename);
            return tmp.exists() && tmp.length() > 0L;
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while examining file " + filename + ". Returning false"), (Throwable)e);
            return false;
        }
    }

    public static Vector<String> populateResults(String filename, Mnemonic mne) throws Exception {
        log.trace((Object)"populateResults called");
        FileInputStream fr = null;
        CipherInputStream ci = null;
        InputStreamReader in = null;
        BufferedReader br = null;
        try {
            Vector<String> results = new Vector<String>();
            fr = new FileInputStream(filename);
            if (mne != null) {
                ci = new CipherInputStream(fr, mne.getDeCipher());
                in = new InputStreamReader(ci);
                log.trace((Object)("Decrypting File: " + filename));
            } else {
                in = new InputStreamReader(fr);
                log.trace((Object)("NOT Decrypting File: " + filename));
            }
            br = new BufferedReader(in);
            RecordParser parse = new RecordParser();
            StringBuffer buf = new StringBuffer();
            boolean inRecord = false;
            String line = br.readLine();
            while (line != null) {
                Vector<Integer> count = parse.containsRecord(line);
                if (count.size() == 0) {
                    if (inRecord) {
                        buf.append(line);
                    }
                } else if (count.size() == 1) {
                    if (inRecord) {
                        buf.append(parse.getHead(line, count.get(0)));
                        results.add(buf.toString());
                    }
                    buf = new StringBuffer();
                    buf.append(parse.getTail(line, count.get(0)));
                    inRecord = true;
                } else {
                    if (inRecord) {
                        buf.append(parse.getHead(line, count.get(0)));
                        results.add(buf.toString());
                    }
                    results.addAll(parse.getFullRecords(line, count));
                    buf = new StringBuffer();
                    buf.append(parse.getTail(line, count.get(count.size() - 1)));
                    inRecord = true;
                }
                line = br.readLine();
            }
            if (inRecord) {
                results.add(buf.toString());
            }
            if (results.size() > 0) {
                results.set(results.size() - 1, ((String)results.get(results.size() - 1)).substring(0, ((String)results.get(results.size() - 1)).lastIndexOf("</Body>")));
            }
            boolean cont = true;
            boolean found = false;
            while (cont) {
                found = false;
                for (int i = 0; i < results.size(); ++i) {
                    if (((String)results.get(i)).trim().length() != 0) continue;
                    found = true;
                    results.remove(i);
                    break;
                }
                if (found) {
                    cont = true;
                    continue;
                }
                cont = false;
            }
            br.close();
            br = null;
            in.close();
            in = null;
            if (mne != null) {
                ci.close();
                ci = null;
            }
            fr.close();
            fr = null;
            return results;
        }
        catch (Exception e) {
            log.error((Object)"Could not populate results. Throwing Exception", (Throwable)e);
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
            throw new Exception("Could not populate results");
        }
    }

    public static String getContent(String file, Mnemonic mne) throws Exception {
        log.trace((Object)("getContent of file : " + file + " called"));
        FileInputStream fr = null;
        CipherInputStream ci = null;
        InputStreamReader in = null;
        BufferedReader br = null;
        try {
            StringBuffer ret = new StringBuffer("");
            fr = new FileInputStream(file);
            if (mne != null && !file.endsWith(".prs")) {
                ci = new CipherInputStream(fr, mne.getDeCipher());
                in = new InputStreamReader(ci);
                log.info((Object)("Decrypting File: " + file));
            } else {
                in = new InputStreamReader(fr);
                log.info((Object)("NOT Decrypting File: " + file));
            }
            br = new BufferedReader(in);
            String record = null;
            while ((record = br.readLine()) != null) {
                ret.append(record);
            }
            br.close();
            br = null;
            fr.close();
            fr = null;
            return ret.toString();
        }
        catch (Exception e) {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
            log.error((Object)("Content of file " + file + " could not be retrived Throwing Exception"), (Throwable)e);
            throw new Exception("Content of file " + file + " could not be retrived");
        }
    }

    public static DataInputStream getBinaryContent(String file, Mnemonic mne) throws Exception {
        log.trace((Object)("getBinaryContent of file : " + file + " called"));
        FileInputStream fr = null;
        CipherInputStream ci = null;
        DataInputStream in = null;
        try {
            fr = new FileInputStream(file);
            if (mne != null && !file.endsWith(".prs")) {
                ci = new CipherInputStream(fr, mne.getDeCipher());
                in = new DataInputStream(ci);
                log.info((Object)("Decrypting File: " + file));
            } else {
                in = new DataInputStream(fr);
                log.info((Object)("NOT Decrypting File: " + file));
            }
            return in;
        }
        catch (Exception e) {
            if (fr != null) {
                fr.close();
            }
            log.error((Object)("Content of file " + file + " could not be retrived Throwing Exception"), (Throwable)e);
            throw new Exception("Content of file " + file + " could not be retrived");
        }
    }

    public static String[] splitFile(String filename) throws Exception {
        FileInputStream in = null;
        try {
            log.trace((Object)("ToSplit:" + filename));
            long length = new File(filename).length();
            long parts = length / (long)RSConstants.partSize;
            if (length % (long)RSConstants.partSize != 0L) {
                ++parts;
            }
            in = new FileInputStream(filename);
            Vector<String> partsNames = new Vector<String>();
            int i = 0;
            while ((long)i < parts) {
                partsNames.add(RSFileHelper.generateName((short)2, null));
                FileOutputStream out = new FileOutputStream(new File(RSFileHelper.publicToTmp((String)partsNames.get(i))));
                int count = 0;
                int read = 0;
                while (count < RSConstants.partSize && read != -1) {
                    byte[] buf = new byte[RSConstants.blockSize];
                    read = in.read(buf);
                    if (read == -1) continue;
                    out.write(buf, 0, read);
                }
                out.close();
                File tmpFile = new File(RSFileHelper.publicToTmp((String)partsNames.get(i)));
                tmpFile.renameTo(new File((String)partsNames.get(i)));
                ++i;
            }
            in.close();
            in = null;
            log.trace((Object)("AfterSplit:" + (String)partsNames.get(0) + " of " + partsNames.size()));
            return partsNames.toArray(new String[0]);
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            log.error((Object)("Could not split file " + filename + ". Throwing Exception"), (Throwable)e);
            throw new Exception("Could not split file " + filename);
        }
    }

    public static void copy(String src, DataOutputStream dst) throws Exception {
        InputStream in = null;
        try {
            int len;
            in = new FileInputStream(new File(src));
            byte[] buf = new byte[RSConstants.transportBlockSize];
            while ((len = in.read(buf)) > 0) {
                dst.writeInt(len);
                dst.write(buf, 0, len);
                log.info((Object)("Sending part (" + len + ") : " + new String(buf)));
            }
            in.close();
            in = null;
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            log.error((Object)("Could not copy file " + src + " to output stream. Throwing Exception"), (Throwable)e);
            throw new Exception("Could not copy file " + src + " to output stream", e);
        }
    }

    public static void copy(String src, String dst) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(new File(src));
            out = new FileOutputStream(new File(RSFileHelper.publicToTmp(dst)));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            in = null;
            out.close();
            out = null;
            File tmpFile = new File(RSFileHelper.publicToTmp(dst));
            tmpFile.renameTo(new File(dst));
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            log.error((Object)("Could not copy file " + src + " to " + dst + ". Throwing Exception"), (Throwable)e);
            throw new Exception("Could not copy file " + src + " to " + dst, e);
        }
    }

    public static void copy(ResultSet rs, String src, DataOutputStream dst) throws Exception {
        log.trace((Object)("Copy file " + src + " to output stream."));
        try {
            int len;
            ResultSetRef ref = rs.getRSRef();
            byte[] buf = new byte[RSConstants.transportBlockSize];
            DataInputStream instring = RSFileHelper.getBinaryContent(src, ref.getMnemonic());
            while ((len = instring.read(buf)) > 0) {
                dst.writeInt(len);
                dst.write(buf, 0, len);
            }
            instring.close();
        }
        catch (Exception e) {
            log.error((Object)("Could not copy file " + src + " to output stream. Throwing Exception"), (Throwable)e);
            throw new Exception("Could not copy file " + src + " to output stream", e);
        }
    }

    public static String persistStream(InputStream content) throws Exception {
        log.trace((Object)"persistStream called");
        DataInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new DataInputStream(content);
            String file = RSFileHelper.generateName((short)2, null);
            log.trace((Object)("persist stream produces this file " + file));
            out = new FileOutputStream(new File(file));
            byte[] buf = new byte[4096];
            int sum = 0;
            while ((len = in.read(buf)) >= 0) {
                sum += len;
                out.write(buf, 0, len);
            }
            in.close();
            in = null;
            out.close();
            out = null;
            return file;
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            log.error((Object)"Could not persist stream. Throwing Exception", (Throwable)e);
            throw new Exception("Could not persist stream", e);
        }
    }

    public static int getNumberOfResultsInTextFile(String filename) throws Exception {
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(new File(filename));
            br = new BufferedReader(fr);
            String line = br.readLine();
            line = br.readLine();
            int count = 0;
            count = line.indexOf("Head") >= 0 ? Integer.parseInt(line.substring("<Head>".length(), line.indexOf("</Head>"))) : (line.indexOf("Body") >= 0 ? 0 : Integer.parseInt(line));
            br.close();
            br = null;
            fr.close();
            fr = null;
            return count;
        }
        catch (Exception e) {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
            log.error((Object)("Could not retrieve number of records from file " + filename + ". Returning 0"), (Throwable)e);
            return 0;
        }
    }

    public static byte[] getBytesFromFile(File file) throws Exception {
        int offset;
        log.trace((Object)"getBytesFromFile called");
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File is too large.");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void runGC() {
        try {
            for (int r = 0; r < 4; ++r) {
                RSFileHelper.forceGC();
            }
        }
        catch (Exception e) {
            log.error((Object)"Caught exception while trying to force garbage collector. Continuing", (Throwable)e);
        }
    }

    private static void forceGC() {
        long usedMem1 = RSFileHelper.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            s_runtime.runFinalization();
            s_runtime.gc();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = RSFileHelper.usedMemory();
        }
    }

    private static long usedMemory() {
        return s_runtime.totalMemory() - s_runtime.freeMemory();
    }
}

