/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.RequestCancelledException;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ResponseHandler;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;

public class RetryHelper {
    public static void retryOrCancel(CoreEnvironment environment, CouchbaseRequest request, RingBuffer<ResponseEvent> responseBuffer) {
        if (environment.retryStrategy().shouldRetry(request, environment)) {
            responseBuffer.publishEvent(ResponseHandler.RESPONSE_TRANSLATOR, request, request.observable());
        } else {
            request.observable().onError((Throwable)new RequestCancelledException("Could not dispatch request, cancelling instead of retrying."));
        }
    }
}

