/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class CallParamRule
extends Rule {
    protected String attributeName = null;
    protected String bodyText = null;
    protected int paramIndex = 0;

    public CallParamRule(Digester digester, int paramIndex) {
        this(paramIndex);
    }

    public CallParamRule(Digester digester, int paramIndex, String attributeName) {
        this(paramIndex, attributeName);
    }

    public CallParamRule(int paramIndex) {
        this(paramIndex, null);
    }

    public CallParamRule(int paramIndex, String attributeName) {
        this.paramIndex = paramIndex;
        this.attributeName = attributeName;
    }

    public void begin(Attributes attributes) throws Exception {
        if (this.attributeName != null) {
            this.bodyText = attributes.getValue(this.attributeName);
        }
    }

    public void body(String bodyText) throws Exception {
        if (this.attributeName == null) {
            this.bodyText = bodyText.trim();
        }
    }

    public void end() throws Exception {
        String[] parameters = (String[])this.digester.peekParams();
        parameters[this.paramIndex] = this.bodyText;
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CallParamRule[");
        sb.append("paramIndex=");
        sb.append(this.paramIndex);
        sb.append(", attributeName=");
        sb.append(this.attributeName);
        sb.append("]");
        return sb.toString();
    }
}

