/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.resources;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.service.Configuration;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.ServiceDependency;
import org.gcube.common.core.scope.GCUBEScope;

public abstract class GCUBEService
extends GCUBEResource {
    public static final String TYPE = "Service";
    private String description;
    private String clazz;
    private String name;
    private String version;
    protected Configuration configuration;
    protected List<ServiceDependency> dependencies = new ArrayList<ServiceDependency>();
    private List<Package> packages = new ArrayList<Package>();
    protected String specificData;
    private static final String VERSION = "1.3.0";

    public GCUBEService() {
        this.type = TYPE;
        this.logger.setPrefix(TYPE);
    }

    @Override
    public synchronized boolean inScope(GCUBEScope ... scopes) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        block0: for (GCUBEScope scope : scopes) {
            for (GCUBEScope resScope : this.getScopes().values()) {
                if (!scope.isEnclosedIn(resScope)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String getServiceClass() {
        return this.clazz;
    }

    public synchronized boolean setServiceClass(String clazz) {
        if (this.clazz == null) {
            this.clazz = clazz;
            return true;
        }
        this.logger.warn("Attempt to change class of gCUbe service " + this.getID() + " from " + this.clazz + " to " + clazz);
        return false;
    }

    public String getServiceName() {
        return this.name;
    }

    public synchronized boolean setServiceName(String name) {
        if (this.name == null) {
            this.name = name;
            return true;
        }
        this.logger.warn("Attempt to change name of gCUbe service " + this.getID() + " from " + this.name + " to " + name);
        return false;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getSpecificData() {
        return this.specificData;
    }

    public void setSpecificData(String specificData) {
        this.specificData = specificData;
    }

    public List<Package> getPackages() {
        return this.packages;
    }

    public List<ServiceDependency> getDependencies() {
        return this.dependencies;
    }

    public String getVersion() {
        return this.version;
    }

    public synchronized boolean setVersion(String version) {
        if (version != null) {
            try {
                this.version = version;
                return true;
            }
            catch (Exception e) {
                this.logger.warn("Accepted version are in the form of \\d{1,2}+.\\d{1,2}+.\\d{1,2}");
                return false;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attempt to change version of gCube service ").append(this.getID()).append(" from ").append(this.version).append(" to ").append(version);
        this.logger.warn(stringBuilder.toString());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public String getLastResourceVersion() {
        return VERSION;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GCUBEService other = (GCUBEService)obj;
        if (this.specificData == null ? other.specificData != null : !this.specificData.equals(other.specificData)) {
            return false;
        }
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.packages == null ? other.packages != null : !this.packages.equals(other.packages)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }
}

