/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.runtime;

import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.kxml.GCUBEResourceImpl;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.common.KPlatform;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KRuntimeResource
extends GCUBERuntimeResource
implements GCUBEResourceImpl {
    @Override
    public synchronized void load(Reader reader) throws Exception {
        KGCUBEResource.load(this, reader);
    }

    @Override
    public synchronized void store(Writer writer) throws Exception {
        KGCUBEResource.store(this, writer);
    }

    @Override
    public InputStream getSchemaResource() {
        return KRuntimeResource.class.getResourceAsStream("/org/gcube/common/resources/kxml/schemas/runtime.xsd");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void load(KXmlParser parser) throws Exception {
        this.accessPoints.clear();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Description")) {
                        this.setDescription(parser.nextText());
                    }
                    if (parser.getName().equals("Category")) {
                        this.setCategory(parser.nextText());
                    }
                    if (parser.getName().equals("Name")) {
                        this.setName(parser.nextText());
                    }
                    if (parser.getName().equals("Version")) {
                        this.setVersion(parser.nextText());
                    }
                    if (parser.getName().equals("Platform")) {
                        this.setPlatform(KPlatform.load(parser, "Platform"));
                    }
                    if (parser.getName().equals("RunTime")) {
                        this.loadRunTime(parser);
                    }
                    if (!parser.getName().equals("AccessPoint")) break;
                    this.loadAccessPoint(parser);
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Profile")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at Profile");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadAccessPoint(KXmlParser parser) throws Exception {
        AccessPoint ap = new AccessPoint();
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Endpoint")) {
                        ap.setEntryname(parser.getAttributeValue(KGCUBEResource.NS, "EntryName"));
                        ap.setEndpoint(parser.nextText());
                    }
                    if (parser.getName().equals("Username")) {
                        ap.setUsername(parser.nextText());
                    }
                    if (parser.getName().equals("Password")) {
                        ap.setPassword(StringEncrypter.getEncrypter().decrypt(parser.nextText(), new Key[0]));
                    }
                    if (parser.getName().equals("Description")) {
                        ap.setDescription(parser.nextText());
                    }
                    if (!parser.getName().equals("Property")) break;
                    this.loadProperty(parser, ap);
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("AccessPoint")) break;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at AccessPoint");
                }
            }
        }
        this.accessPoints.add(ap);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadProperty(KXmlParser parser, AccessPoint ap) throws Exception {
        String name = "invalid";
        String value = "invalid";
        boolean encrypted = false;
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Name")) {
                        name = parser.nextText();
                    }
                    if (!parser.getName().equals("Value")) break;
                    if (Boolean.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "encrypted")).booleanValue()) {
                        encrypted = true;
                        value = StringEncrypter.getEncrypter().decrypt(parser.nextText(), new Key[0]);
                        break;
                    }
                    value = parser.nextText();
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Property")) break;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at Property");
                }
            }
        }
        ap.addProperty(name, value, encrypted);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadRunTime(KXmlParser parser) throws Exception {
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("HostedOn")) {
                        this.setHostedOn(parser.nextText());
                    }
                    if (parser.getName().equals("GHN")) {
                        this.setGHN(parser.getAttributeValue(KGCUBEResource.NS, "UniqueID"));
                    }
                    if (!parser.getName().equals("Status")) break;
                    this.setStatus(parser.nextText());
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("RunTime")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at RunTime");
                }
            }
        }
    }

    @Override
    public void store(KXmlSerializer serializer) throws Exception {
        serializer.startTag(KGCUBEResource.NS, "Profile");
        if (this.getCategory() != null) {
            serializer.startTag(KGCUBEResource.NS, "Category").text(this.getCategory()).endTag(KGCUBEResource.NS, "Category");
        }
        if (this.getName() != null) {
            serializer.startTag(KGCUBEResource.NS, "Name").text(this.getName()).endTag(KGCUBEResource.NS, "Name");
        }
        if (this.getVersion() != null) {
            serializer.startTag(KGCUBEResource.NS, "Version").text(this.getVersion()).endTag(KGCUBEResource.NS, "Version");
        }
        if (this.getDescription() != null) {
            serializer.startTag(KGCUBEResource.NS, "Description").text(this.getDescription()).endTag(KGCUBEResource.NS, "Description");
        }
        if (this.getPlatform() != null) {
            KPlatform.store(this.getPlatform(), serializer, "Platform");
        }
        serializer.startTag(KGCUBEResource.NS, "RunTime");
        if (this.getHostedOn() != null) {
            serializer.startTag(KGCUBEResource.NS, "HostedOn").text(this.getHostedOn()).endTag(KGCUBEResource.NS, "HostedOn");
        }
        if (this.getGHN() != null) {
            serializer.startTag(KGCUBEResource.NS, "GHN").attribute(KGCUBEResource.NS, "UniqueID", this.getGHN()).endTag(KGCUBEResource.NS, "GHN");
        }
        if (this.getStatus() != null) {
            serializer.startTag(KGCUBEResource.NS, "Status").text(this.getStatus()).endTag(KGCUBEResource.NS, "Status");
        }
        serializer.endTag(KGCUBEResource.NS, "RunTime");
        if (this.getAccessPoints() != null) {
            for (AccessPoint ap : this.getAccessPoints()) {
                serializer.startTag(KGCUBEResource.NS, "AccessPoint");
                if (ap.getDescription() != null) {
                    serializer.startTag(KGCUBEResource.NS, "Description").text(ap.getDescription()).endTag(KGCUBEResource.NS, "Description");
                }
                serializer.startTag(KGCUBEResource.NS, "Interface");
                serializer.startTag(KGCUBEResource.NS, "Endpoint").attribute(KGCUBEResource.NS, "EntryName", ap.getEntryname()).text(ap.getEndpoint()).endTag(KGCUBEResource.NS, "Endpoint");
                serializer.endTag(KGCUBEResource.NS, "Interface");
                if (ap.getUsername() != null) {
                    serializer.startTag(KGCUBEResource.NS, "AccessData");
                    serializer.startTag(KGCUBEResource.NS, "Username").text(ap.getUsername()).endTag(KGCUBEResource.NS, "Username");
                    if (ap.getPassword() != null) {
                        serializer.startTag(KGCUBEResource.NS, "Password").text(StringEncrypter.getEncrypter().encrypt(ap.getPassword(), new Key[0])).endTag(KGCUBEResource.NS, "Password");
                    }
                    serializer.endTag(KGCUBEResource.NS, "AccessData");
                }
                if (!ap.getAllPropertyNames().isEmpty()) {
                    serializer.startTag(KGCUBEResource.NS, "Properties");
                    for (String name : ap.getAllPropertyNames()) {
                        serializer.startTag(KGCUBEResource.NS, "Property");
                        serializer.startTag(KGCUBEResource.NS, "Name").text(name).endTag(KGCUBEResource.NS, "Name");
                        serializer.startTag(KGCUBEResource.NS, "Value");
                        if (ap.isPropertyEncrypted(name)) {
                            serializer.attribute(KGCUBEResource.NS, "encrypted", "true").text(StringEncrypter.getEncrypter().encrypt(ap.getProperty(name), new Key[0]));
                        } else {
                            serializer.attribute(KGCUBEResource.NS, "encrypted", "false").text(ap.getProperty(name));
                        }
                        serializer.endTag(KGCUBEResource.NS, "Value");
                        serializer.endTag(KGCUBEResource.NS, "Property");
                    }
                    serializer.endTag(KGCUBEResource.NS, "Properties");
                }
                serializer.endTag(KGCUBEResource.NS, "AccessPoint");
            }
        }
        serializer.endTag(KGCUBEResource.NS, "Profile");
    }

    public static void main(String[] args) {
        KRuntimeResource rt = new KRuntimeResource();
        StringWriter sw = new StringWriter();
        try {
            System.out.println("Loading resource from file...");
            KGCUBEResource.load(rt, new FileReader(args[0]));
            System.out.println("OK");
            System.out.println("Deserializing the resource...");
            KGCUBEResource.store(rt, sw);
            System.out.println(sw.toString());
            System.out.println("OK");
            System.out.println("Checking deserialization...");
            KGCUBEResource.load(rt, new StringReader(sw.toString()));
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

