/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.service;

import org.gcube.common.core.resources.service.Dependency;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.service.version.VersionSpecificationParser;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KDependency {
    /*
     * Enabled aggressive block sorting
     */
    public static Dependency load(KXmlParser parser) throws Exception {
        Dependency d = new Dependency();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Service")) {
                        d.setService(KService.load(parser));
                    }
                    if (parser.getName().equals("Package")) {
                        d.setPackage(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Version")) {
                        String v = parser.nextText().trim();
                        VersionSpecificationParser.parse(v);
                        d.setVersion(v.trim());
                    }
                    if (parser.getName().equals("Scope")) {
                        d.setScope(Package.ScopeLevel.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "level").trim()));
                    }
                    if (!parser.getName().equals("Optional")) break;
                    d.setOptional(Boolean.valueOf(parser.nextText().trim()));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Dependency")) break;
                    return d;
                }
                case 1: {
                    throw new Exception("Parsing failed at Dependency");
                }
            }
        }
    }

    public static void store(Dependency component, KXmlSerializer serializer) throws Exception {
        if (component == null) {
            return;
        }
        serializer.startTag(KGCUBEResource.NS, "Dependency");
        KService.store(component.getService(), serializer);
        serializer.startTag(KGCUBEResource.NS, "Package").text(component.getPackage().trim()).endTag(KGCUBEResource.NS, "Package");
        if (component.getVersion() != null) {
            VersionSpecificationParser.parse(component.getVersion());
            serializer.startTag(KGCUBEResource.NS, "Version").text(component.getVersion().trim()).endTag(KGCUBEResource.NS, "Version");
        }
        if (component.getScope() != null) {
            serializer.startTag(KGCUBEResource.NS, "Scope").attribute(KGCUBEResource.NS, "level", component.getScope().toString()).endTag(KGCUBEResource.NS, "Scope");
        }
        serializer.startTag(KGCUBEResource.NS, "Optional").text(component.getOptional().toString()).endTag(KGCUBEResource.NS, "Optional");
        serializer.endTag(KGCUBEResource.NS, "Dependency");
    }

    static class KService {
        KService() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public static Dependency.Service load(KXmlParser parser) throws Exception {
            Dependency.Service s = new Dependency.Service();
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("Name")) {
                            s.setName(parser.nextText().trim());
                        }
                        if (parser.getName().equals("Class")) {
                            s.setClazz(parser.nextText().trim());
                        }
                        if (!parser.getName().equals("Version")) break;
                        s.setVersion(parser.nextText().trim());
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("Service")) break;
                        return s;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at Service");
                    }
                }
            }
        }

        public static void store(Dependency.Service component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "Service");
            if (component.getClazz() != null) {
                serializer.startTag(KGCUBEResource.NS, "Class").text(component.getClazz().trim()).endTag(KGCUBEResource.NS, "Class");
            }
            if (component.getName() != null) {
                serializer.startTag(KGCUBEResource.NS, "Name").text(component.getName().trim()).endTag(KGCUBEResource.NS, "Name");
            }
            if (component.getVersion() != null) {
                serializer.startTag(KGCUBEResource.NS, "Version").text(component.getVersion().trim()).endTag(KGCUBEResource.NS, "Version");
            }
            serializer.endTag(KGCUBEResource.NS, "Service");
        }
    }
}

