/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.test.channel;

import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.events.StringPayloadChannelEvent;
import gr.uoa.di.madgik.commons.channel.nozzle.ChannelInlet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InletThread
extends Thread
implements Observer {
    private static Logger logger = Logger.getLogger(InletThread.class.getName());
    private ChannelInlet Inlet = null;
    private int NumberOfEventsToProduce = 0;
    private final Object synchThreadStart = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InletThread(ChannelInlet Inlet, int NumberOfEventsToProduce) {
        this.Inlet = Inlet;
        this.NumberOfEventsToProduce = NumberOfEventsToProduce;
        this.setName(InletThread.class.getName());
        this.setDaemon(true);
        Iterator<ChannelStateEvent> iterator = this.synchThreadStart;
        synchronized (iterator) {
            this.start();
            try {
                this.synchThreadStart.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (ChannelStateEvent ev : this.Inlet.GetNozzleEvents()) {
            ev.addObserver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.synchThreadStart;
        synchronized (object) {
            this.synchThreadStart.notify();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Going to wait for a bit before starting producing");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.NumberOfEventsToProduce; ++i) {
            this.Inlet.Push(new StringPayloadChannelEvent("INLET(1) event " + i));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Done producing. going to wait for a bit");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Done waiting. going to dispose");
        }
        this.Inlet.Dispose();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Done disposing. going to wait for a bit");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Done waiting. Exiting");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Caught event has argument other than the one registered for. Disgarding");
            }
            return;
        }
        if (!(arg instanceof ChannelStateEvent)) {
            return;
        }
        if (arg instanceof StringPayloadChannelEvent) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Inlet received " + (Object)((Object)((ChannelStateEvent)arg).GetEventName()) + " with payload '" + ((StringPayloadChannelEvent)arg).GetValue() + "'");
            }
        } else if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Inlet received " + (Object)((Object)((ChannelStateEvent)arg).GetEventName()));
        }
    }
}

