/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import java.math.BigInteger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class GCMBlockCipher
implements AEADBlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final byte[] ZEROES = new byte[16];
    private static final BigInteger R = new BigInteger("11100001", 2).shiftLeft(120);
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private final BlockCipher cipher;
    private boolean forEncryption;
    private int macSize;
    private byte[] nonce;
    private byte[] A;
    private KeyParameter keyParam;
    private BigInteger H;
    private BigInteger initS;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private BigInteger S;
    private byte[] counter;
    private int bufOff;
    private long totalLength;

    public GCMBlockCipher(BlockCipher blockCipher) {
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        this.cipher = blockCipher;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCM";
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        Object object;
        this.forEncryption = bl;
        this.macSize = 16;
        this.macBlock = null;
        int n = bl ? 16 : 16 + this.macSize;
        this.bufBlock = new byte[n];
        if (cipherParameters instanceof AEADParameters) {
            object = (AEADParameters)cipherParameters;
            this.nonce = ((AEADParameters)object).getNonce();
            this.A = ((AEADParameters)object).getAssociatedText();
            if (((AEADParameters)object).getMacSize() != 128) {
                throw new IllegalArgumentException("only 128-bit MAC supported currently");
            }
            this.keyParam = ((AEADParameters)object).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            object = (ParametersWithIV)cipherParameters;
            this.nonce = ((ParametersWithIV)object).getIV();
            this.A = null;
            this.keyParam = (KeyParameter)((ParametersWithIV)object).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        if (this.nonce == null || this.nonce.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (this.A == null) {
            this.A = new byte[0];
        }
        this.cipher.init(true, this.keyParam);
        object = new byte[16];
        this.cipher.processBlock(ZEROES, 0, (byte[])object, 0);
        this.H = new BigInteger(1, (byte[])object);
        this.initS = this.gHASH(this.A, false);
        if (this.nonce.length == 12) {
            this.J0 = new byte[16];
            System.arraycopy(this.nonce, 0, this.J0, 0, this.nonce.length);
            this.J0[15] = 1;
        } else {
            BigInteger bigInteger = this.gHASH(this.nonce, true);
            BigInteger bigInteger2 = BigInteger.valueOf(this.nonce.length * 8);
            bigInteger = this.multiply(bigInteger.xor(bigInteger2), this.H);
            this.J0 = this.asBlock(bigInteger);
        }
        this.S = this.initS;
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
    }

    public byte[] getMac() {
        return Arrays.clone(this.macBlock);
    }

    public int getOutputSize(int n) {
        if (this.forEncryption) {
            return n + this.bufOff + this.macSize;
        }
        return n + this.bufOff - this.macSize;
    }

    public int getUpdateOutputSize(int n) {
        return (n + this.bufOff) / 16 * 16;
    }

    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        return this.process(by, byArray, n);
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        int n4 = 0;
        for (int i = 0; i != n2; ++i) {
            n4 += this.process(byArray[n + i], byArray2, n3 + n4);
        }
        return n4;
    }

    private int process(byte by, byte[] byArray, int n) throws DataLengthException {
        this.bufBlock[this.bufOff++] = by;
        if (this.bufOff == this.bufBlock.length) {
            this.gCTRBlock(this.bufBlock, 16, byArray, n);
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, 16);
            }
            this.bufOff = this.bufBlock.length - 16;
            return 16;
        }
        return 0;
    }

    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        Object object;
        int n2 = this.bufOff;
        if (!this.forEncryption) {
            if (n2 < this.macSize) {
                throw new InvalidCipherTextException("data too short");
            }
            n2 -= this.macSize;
        }
        if (n2 > 0) {
            object = new byte[16];
            System.arraycopy(this.bufBlock, 0, object, 0, n2);
            this.gCTRBlock((byte[])object, n2, byArray, n);
        }
        object = BigInteger.valueOf(this.A.length * 8).shiftLeft(64).add(BigInteger.valueOf(this.totalLength * 8L));
        this.S = this.multiply(this.S.xor((BigInteger)object), this.H);
        byte[] byArray2 = new byte[16];
        this.cipher.processBlock(this.J0, 0, byArray2, 0);
        BigInteger bigInteger = this.S.xor(new BigInteger(1, byArray2));
        byte[] byArray3 = this.asBlock(bigInteger);
        int n3 = n2;
        if (this.forEncryption) {
            this.macBlock = byArray3;
            System.arraycopy(byArray3, 0, byArray, n + this.bufOff, byArray3.length);
            n3 += byArray3.length;
        } else {
            this.macBlock = new byte[this.macSize];
            System.arraycopy(this.bufBlock, n2, this.macBlock, 0, this.macSize);
            if (!Arrays.areEqual(byArray3, this.macBlock)) {
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
        }
        this.reset(false);
        return n3;
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl) {
        this.S = this.initS;
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.bufBlock != null) {
            Arrays.fill(this.bufBlock, (byte)0);
        }
        if (bl) {
            this.macBlock = null;
        }
        this.cipher.reset();
    }

    private void gCTRBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        GCMBlockCipher.inc(this.counter);
        byte[] byArray3 = new byte[16];
        this.cipher.processBlock(this.counter, 0, byArray3, 0);
        if (this.forEncryption) {
            System.arraycopy(ZEROES, n, byArray3, n, 16 - n);
            for (int i = n - 1; i >= 0; --i) {
                int n3 = i;
                byArray3[n3] = (byte)(byArray3[n3] ^ byArray[i]);
                byArray2[n2 + i] = byArray3[i];
            }
            this.gHASHBlock(byArray3);
        } else {
            for (int i = n - 1; i >= 0; --i) {
                int n4 = i;
                byArray3[n4] = (byte)(byArray3[n4] ^ byArray[i]);
                byArray2[n2 + i] = byArray3[i];
            }
            this.gHASHBlock(byArray);
        }
        this.totalLength += (long)n;
    }

    private BigInteger gHASH(byte[] byArray, boolean bl) {
        BigInteger bigInteger = ZERO;
        for (int i = 0; i < byArray.length; i += 16) {
            byte[] byArray2 = new byte[16];
            int n = Math.min(byArray.length - i, 16);
            System.arraycopy(byArray, i, byArray2, 0, n);
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            bigInteger = this.multiply(bigInteger.xor(bigInteger2), this.H);
        }
        return bigInteger;
    }

    private void gHASHBlock(byte[] byArray) {
        Object object;
        if (byArray.length > 16) {
            object = new byte[16];
            System.arraycopy(byArray, 0, object, 0, 16);
            byArray = object;
        }
        object = new BigInteger(1, byArray);
        this.S = this.multiply(this.S.xor((BigInteger)object), this.H);
    }

    private static void inc(byte[] byArray) {
        for (int i = 15; i >= 12; --i) {
            byte by;
            byArray[i] = by = (byte)(byArray[i] + 1 & 0xFF);
            if (by != 0) break;
        }
    }

    private BigInteger multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ZERO;
        BigInteger bigInteger4 = bigInteger;
        for (int i = 0; i < 128; ++i) {
            if (bigInteger2.testBit(127 - i)) {
                bigInteger3 = bigInteger3.xor(bigInteger4);
            }
            boolean bl = bigInteger4.testBit(0);
            bigInteger4 = bigInteger4.shiftRight(1);
            if (!bl) continue;
            bigInteger4 = bigInteger4.xor(R);
        }
        return bigInteger3;
    }

    private byte[] asBlock(BigInteger bigInteger) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
        if (byArray.length < 16) {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

