/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.encoding;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.globus.util.I18n;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.encoding.ObjectDeserializationContext;
import org.globus.wsrf.utils.Resources;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ObjectDeserializer {
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());

    public static Object toObject(Element element) throws DeserializationException {
        return ObjectDeserializer.toObject(element, null);
    }

    public static Object toObject(Element element, Class javaClass) throws DeserializationException {
        ObjectDeserializationContext deserializer = new ObjectDeserializationContext(element, javaClass);
        try {
            deserializer.parse();
        }
        catch (Exception e) {
            throw new DeserializationException(i18n.getMessage("genericDeserializationError"), e);
        }
        return deserializer.getValue();
    }

    public static Object toObject(SOAPElement element) throws DeserializationException {
        return ObjectDeserializer.toObject(element, null);
    }

    public static Object toObject(SOAPElement element, Class javaClass) throws DeserializationException {
        if (!(element instanceof MessageElement)) {
            throw new DeserializationException(i18n.getMessage("unsupportedType"));
        }
        MessageElement elem = (MessageElement)element;
        if (elem.getDeserializationContext() != null && !elem.isDirty()) {
            try {
                return elem.getValueAsType(elem.getType(), javaClass);
            }
            catch (Exception e) {
                throw new DeserializationException(i18n.getMessage("genericDeserializationError"), e);
            }
        }
        ObjectDeserializationContext deserializer = new ObjectDeserializationContext(elem, javaClass);
        try {
            deserializer.parse();
        }
        catch (Exception e) {
            throw new DeserializationException(i18n.getMessage("genericDeserializationError"), e);
        }
        return deserializer.getValue();
    }

    public static Object[] toObject(SOAPElement[] elements) throws DeserializationException {
        return ObjectDeserializer.toObject(elements, null);
    }

    public static Object[] toObject(SOAPElement[] elements, Class javaClass) throws DeserializationException {
        if (elements == null) {
            return null;
        }
        Object[] objects = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            objects[i] = ObjectDeserializer.toObject(elements[i], javaClass);
        }
        return objects;
    }

    public static Object[] toObject(AnyContentType any) throws DeserializationException {
        return ObjectDeserializer.toObject(any, null);
    }

    public static Object[] toObject(AnyContentType any, Class javaClass) throws DeserializationException {
        if (any == null) {
            return null;
        }
        return ObjectDeserializer.toObject((SOAPElement[])any.get_any(), javaClass);
    }

    public static Object getFirstAsObject(AnyContentType any) throws DeserializationException {
        return ObjectDeserializer.getFirstAsObject(any, null);
    }

    public static Object getFirstAsObject(AnyContentType any, Class javaClass) throws DeserializationException {
        if (any == null || any.get_any() == null || any.get_any().length == 0) {
            return null;
        }
        return ObjectDeserializer.toObject((SOAPElement)any.get_any()[0], javaClass);
    }

    public static boolean contains(SOAPElement element, Class javaClass) {
        if (element == null || javaClass == null) {
            throw new IllegalArgumentException();
        }
        if (!(element instanceof MessageElement)) {
            throw new IllegalArgumentException();
        }
        TypeDesc desc = TypeDesc.getTypeDescForClass((Class)javaClass);
        if (desc == null) {
            return false;
        }
        QName qname = desc.getXmlType();
        QName type = ((MessageElement)element).getType();
        if (type == null) {
            type = ((MessageElement)element).getQName();
        }
        return type != null && qname != null && type.equals(qname);
    }

    public static Object deserialize(InputSource input, Class javaClass) throws DeserializationException {
        ObjectDeserializationContext deserializer = new ObjectDeserializationContext(input, javaClass);
        try {
            deserializer.parse();
        }
        catch (Exception e) {
            throw new DeserializationException(i18n.getMessage("genericDeserializationError"), e);
        }
        return deserializer.getValue();
    }
}

