/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.descriptor.util.ElementHandler;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.util.errors", (ClassLoader)ElementParser.class.getClassLoader());
    protected transient Map elementHandlers;
    private QName elemName;

    protected ElementParser() {
    }

    public ElementParser(QName elemName) {
        this.elementHandlers = new HashMap();
        this.elemName = elemName;
    }

    public void register(QName name, ElementHandler handler) {
        this.elementHandlers.put(name, handler);
    }

    public void parse(Element configElement) throws ElementParserException {
        ElementParser.checkElement(configElement, this.elemName);
        for (Node currentChild = configElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            Element elem = (Element)currentChild;
            QName name = ElementParser.getQName(elem);
            ElementHandler handler = (ElementHandler)this.elementHandlers.get(name);
            if (handler == null) {
                throw new ElementParserException(i18n.getMessage("noHandler", (Object)name));
            }
            handler.parse(elem);
        }
    }

    public static QName getQName(Node node) {
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static void checkElement(Element configElement, QName expectedName) throws ElementParserException {
        QName cfgName;
        if (expectedName != null && !(cfgName = ElementParser.getQName(configElement)).equals(expectedName)) {
            throw new ElementParserException(i18n.getMessage("invalidElement", new Object[]{cfgName, expectedName}));
        }
    }

    public static Node getFirstChildElement(Node elem) {
        for (Node currentChild = elem.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            return (Element)currentChild;
        }
        return null;
    }
}

