/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class IvParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv;

    public IvParameterSpec(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("null iv passed");
        }
        this.iv = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.iv, 0, byArray.length);
    }

    public IvParameterSpec(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null iv passed");
        }
        if (n < 0 || n2 < 0 || byArray.length - n < n2) {
            throw new IllegalArgumentException("Bad offset/len");
        }
        this.iv = new byte[n2];
        System.arraycopy(byArray, n, this.iv, 0, n2);
    }

    public byte[] getIV() {
        byte[] byArray = new byte[this.iv.length];
        System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
        return byArray;
    }
}

