/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.HostPort;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.Task;
import org.globus.ftp.extended.GridFTPServerFacade;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;
import org.globus.net.SocketFactory;

public class GridFTPActiveConnectTask
extends Task {
    private static Log logger = LogFactory.getLog((class$org$globus$ftp$dc$GridFTPActiveConnectTask == null ? (class$org$globus$ftp$dc$GridFTPActiveConnectTask = GridFTPActiveConnectTask.class$("org.globus.ftp.dc.GridFTPActiveConnectTask")) : class$org$globus$ftp$dc$GridFTPActiveConnectTask).getName());
    protected HostPort hostPort;
    protected BasicServerControlChannel control;
    protected SocketBox box;
    protected GridFTPSession gSession;
    static /* synthetic */ Class class$org$globus$ftp$dc$GridFTPActiveConnectTask;

    public GridFTPActiveConnectTask(HostPort hostPort, BasicServerControlChannel control, SocketBox box, GridFTPSession gSession) {
        if (box == null) {
            throw new IllegalArgumentException("Socket box is null");
        }
        this.hostPort = hostPort;
        this.control = control;
        this.box = box;
        this.gSession = gSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Socket mySocket = null;
        if (logger.isDebugEnabled()) {
            logger.debug("connecting new socket to: " + this.hostPort.getHost() + " " + this.hostPort.getPort());
        }
        SocketFactory factory = SocketFactory.getDefault();
        try {
            mySocket = factory.createSocket(this.hostPort.getHost(), this.hostPort.getPort());
            if (this.gSession.TCPBufferSize != -1) {
                logger.debug("setting socket's TCP buffer size to " + this.gSession.TCPBufferSize);
                mySocket.setReceiveBufferSize(this.gSession.TCPBufferSize);
                mySocket.setSendBufferSize(this.gSession.TCPBufferSize);
            }
            if (!this.gSession.dataChannelAuthentication.equals(DataChannelAuthentication.NONE)) {
                logger.debug("authenticating");
                mySocket = GridFTPServerFacade.authenticate(mySocket, true, this.gSession.credential, this.gSession.dataChannelProtection, this.gSession.dataChannelAuthentication);
            } else {
                logger.debug("not authenticating");
            }
            SocketBox socketBox = this.box;
            synchronized (socketBox) {
                this.box.setSocket(mySocket);
            }
        }
        catch (Exception e) {
            FTPServerFacade.exceptionToControlChannel(e, "active connection to server failed", this.control);
            try {
                if (mySocket != null) {
                    mySocket.close();
                }
            }
            catch (Exception second) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

