/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.tcp;

import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.events.EventFactory;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryEntry;
import gr.uoa.di.madgik.commons.channel.registry.RegisteredNozzle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InletProtocol
extends Thread
implements Observer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(InletProtocol.class.getName());
    private ChannelRegistryEntry Entry = null;
    private Object synchThreadStart = null;
    private List<ChannelStateEvent> EventsToSend = null;
    private final Boolean synchEventsToSend = new Boolean(false);
    private static final long MaximumWaitPeriodinMilliseconds = 60000L;
    private static final long WaitPeriodinMilliseconds = 50L;
    private Boolean InDispose = false;

    public InletProtocol(ChannelRegistryEntry Entry2, Object synchThreadStart) {
        this.Entry = Entry2;
        this.synchThreadStart = synchThreadStart;
        this.setName(InletProtocol.class.getName());
        this.setDaemon(true);
        this.start();
    }

    public void Dispose() {
        this.InDispose = true;
        try {
            for (ChannelStateEvent ev : this.Entry.GetState().GetChannelEvents()) {
                ev.deleteObserver(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.EventsToSend.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            block10: {
                this.EventsToSend = new ArrayList<ChannelStateEvent>();
                try {
                    for (ChannelStateEvent ev : this.Entry.GetState().GetChannelEvents()) {
                        ev.addObserver(this);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.FINE)) break block10;
                    logger.log(Level.FINE, "Inlet protocol thread could not complete normally", ex);
                }
            }
            Object ex = this.synchThreadStart;
            synchronized (ex) {
                this.synchThreadStart.notify();
            }
            try {
                while (!this.InDispose.booleanValue()) {
                    List<RegisteredNozzle> Nozzles = this.Entry.GetRegisteredNozzles();
                    this.ReceiveIncomingEvents(Nozzles);
                    this.EmitOutgoingEvents(Nozzles);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Break Iteration");
                }
            }
            catch (Exception ex2) {
                if (this.InDispose.booleanValue() || !logger.isLoggable(Level.FINE)) break block11;
                logger.log(Level.FINE, "Inlet protocol thread could not complete normally", ex2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void EmitOutgoingEvents(List<RegisteredNozzle> Nozzles) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Emiting Outgoing events");
        }
        ArrayList<ChannelStateEvent> TmpEvents = new ArrayList<ChannelStateEvent>();
        Boolean bl = this.synchEventsToSend;
        synchronized (bl) {
            TmpEvents.addAll(this.EventsToSend);
            this.EventsToSend.clear();
        }
        for (RegisteredNozzle nozzle : Nozzles) {
            try {
                if (nozzle.GetClientSock() == null) continue;
                DataOutputStream dout = new DataOutputStream(nozzle.GetClientSock().getOutputStream());
                int count = 0;
                for (ChannelStateEvent ev : TmpEvents) {
                    if (!ev.GetEmitingNozzleID().equals(nozzle.GetNozzleID())) continue;
                    ++count;
                }
                int evtosend = TmpEvents.size() - count;
                if (evtosend < 0) {
                    evtosend = 0;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Number of Outgoing events is " + evtosend);
                }
                dout.writeInt(evtosend);
                dout.flush();
                for (ChannelStateEvent ev : TmpEvents) {
                    if (ev.GetEmitingNozzleID().equals(nozzle.GetNozzleID())) continue;
                    dout.writeUTF(ev.GetEventName().toString());
                    byte[] evbuf = ev.Encode();
                    dout.writeInt(evbuf.length);
                    dout.write(evbuf);
                }
                dout.flush();
            }
            catch (Exception ex) {
                nozzle.Dispose();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Finished Emiting Outgoing events");
        }
    }

    private void ReceiveIncomingEvents(List<RegisteredNozzle> Nozzles) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Receiving Incoming events");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Waiting for everyone to be able to transmit");
        }
        this.WaitForAll(Nozzles);
        if (this.InDispose.booleanValue()) {
            return;
        }
        for (RegisteredNozzle nozzle : Nozzles) {
            try {
                DataInputStream din;
                if (nozzle.GetClientSock() == null || (din = new DataInputStream(nozzle.GetClientSock().getInputStream())).available() <= 0) continue;
                int incoming = din.readInt();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Number of Incoming events is " + incoming);
                }
                for (int i = 0; i < incoming; ++i) {
                    ChannelStateEvent evv;
                    ChannelStateEvent ev;
                    ChannelState.EventName evtype = ChannelState.EventName.valueOf(din.readUTF());
                    int size = din.readInt();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "size of event is " + size);
                    }
                    byte[] evbuf = new byte[size];
                    din.readFully(evbuf);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "read event is " + evbuf.length);
                    }
                    if ((ev = EventFactory.GetEvent(evtype, evbuf)).GetEmitingNozzleID().equals(this.Entry.GetInletNozzleID()) || (evv = this.Entry.GetState().GetEvent(ev.GetEventName())) == null) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Emiting received " + ev.GetEventName().toString());
                    }
                    evv.NotifyChange(ev);
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Problem receiving events from nozzle. Disposing nozzle", ex);
                }
                nozzle.Dispose();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Finished receiving Incoming events");
        }
    }

    private void WaitForAll(List<RegisteredNozzle> Nozzles) {
        block6: for (RegisteredNozzle nozzle : Nozzles) {
            if (this.InDispose.booleanValue()) {
                return;
            }
            try {
                if (nozzle.GetClientSock() == null) continue;
                if (nozzle.GetClientSock().isClosed()) {
                    nozzle.Dispose();
                    continue;
                }
                long sleepedSoFar = 0L;
                while (true) {
                    if (this.InDispose.booleanValue()) {
                        return;
                    }
                    if (sleepedSoFar > 60000L) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Disposing nozzle because of maximum amount reached");
                        }
                        nozzle.Dispose();
                        continue block6;
                    }
                    if (new DataInputStream(nozzle.GetClientSock().getInputStream()).available() > 0) continue block6;
                    try {
                        Thread.sleep(50L);
                        sleepedSoFar += 50L;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Disposing nozzle because of error " + ex.getMessage());
                }
                nozzle.Dispose();
            }
        }
        if (Nozzles.size() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Caught event has argument other than the one registered for. Disgarding");
            }
            return;
        }
        if (arg instanceof ChannelStateEvent) {
            Boolean bl = this.synchEventsToSend;
            synchronized (bl) {
                this.EventsToSend.add((ChannelStateEvent)arg);
            }
        }
    }
}

