/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.generic;

import java.net.MalformedURLException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.apache.axis.Constants;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.informationsystem.publisher.ISGenericPublisher;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.context.ISPublisherContext;
import org.gcube.informationsystem.collector.stubs.wsdai.DataResourceUnavailableFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.InvalidResourceNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.NotAuthorizedFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.ServiceBusyFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentRequestWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentsResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.InvalidCollectionNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentRequestWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentResponseWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentsResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLCollectionAccessPT;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLWrapperType;
import org.gcube.informationsystem.collector.stubs.wsdaix.service.WsdaixServiceAddressingLocator;
import org.w3c.dom.Document;

class CollectorClient {
    protected static final GCUBELog logger = new GCUBELog(ISGenericPublisher.class);
    protected static final int DEFAULT_CALL_TIMEOUT = 120000;

    CollectorClient() {
    }

    protected static void removeDocuments(EndpointReferenceType sink, GCUBEScope scope, URI resourceName, URI collectionURI, String[] documentNames) throws DataResourceUnavailableFaultType, MalformedURLException, RemoteException, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType, NotAuthorizedFaultType {
        RemoveDocumentResponseWrapper[] rwrappers;
        logger.trace((Object)("Removing document from " + sink.getAddress().toString()));
        RemoveDocumentsRequest request = new RemoveDocumentsRequest();
        request.setDataResourceAbstractName(resourceName);
        RemoveDocumentRequestWrapper[] wrappers = new RemoveDocumentRequestWrapper[documentNames.length];
        for (int i = 0; i < documentNames.length; ++i) {
            wrappers[i] = new RemoveDocumentRequestWrapper();
            wrappers[i].setDocumentName(documentNames[i]);
        }
        request.setRemoveDocumentRequestWrapper(wrappers);
        request.setCollectionName(collectionURI);
        XMLCollectionAccessPT stubs = null;
        try {
            stubs = new WsdaixServiceAddressingLocator().getXMLCollectionAccessPTPort(sink);
            stubs = (XMLCollectionAccessPT)GCUBERemotePortTypeContext.getProxy((Remote)stubs, (GCUBEScope)scope, (int)CollectorClient.getTimeout(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to remove the resource", (Throwable)e);
        }
        RemoveDocumentsResponse response = stubs.removeDocuments(request);
        for (RemoveDocumentResponseWrapper wrapper : rwrappers = response.getRemoveDocumentResponseWrapper()) {
            logger.trace((Object)("Document name " + wrapper.getDocumentName()));
            logger.trace((Object)("Returned response from remove operation " + wrapper.getResponse().toString()));
        }
    }

    protected static void addDocuments(EndpointReferenceType sink, GCUBEScope scope, URI resourceName, URI collectionURI, String[] documentNames, Document[] documents, Document[] metadata) throws Exception {
        logger.trace((Object)("Sending resource to " + sink.getAddress().toString()));
        AddDocumentsRequest request = new AddDocumentsRequest();
        request.setDataResourceAbstractName(resourceName);
        AddDocumentRequestWrapper[] wrappers = new AddDocumentRequestWrapper[documentNames.length];
        for (int i = 0; i < documentNames.length; ++i) {
            wrappers[i] = new AddDocumentRequestWrapper();
            wrappers[i].setDocumentName(documentNames[i]);
            XMLWrapperType wrapper = new XMLWrapperType();
            MessageElement msgElement = new MessageElement("http://www.globus.org/namespaces/2004/06/core", "ISPublisher", (Object)documents[i]);
            msgElement.setType(Constants.XSD_ANYTYPE);
            if (metadata != null) {
                try {
                    MessageElement msgElement2 = new MessageElement("http://www.globus.org/namespaces/2004/06/core", "ISPublisher", (Object)metadata[i].getDocumentElement());
                    msgElement2.setType(Constants.XSD_ANYTYPE);
                    wrapper.set_any(new MessageElement[]{msgElement, msgElement2});
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to add the document metadata for " + documentNames[i]), (Throwable)e);
                    throw e;
                }
            } else {
                wrapper.set_any(new MessageElement[]{msgElement});
            }
            wrappers[i].setData(wrapper);
        }
        request.setAddDocumentRequestWrapper(wrappers);
        request.setCollectionName(collectionURI);
        XMLCollectionAccessPT stubs = null;
        try {
            stubs = new WsdaixServiceAddressingLocator().getXMLCollectionAccessPTPort(sink);
            stubs = (XMLCollectionAccessPT)GCUBERemotePortTypeContext.getProxy((Remote)stubs, (GCUBEScope)scope, (int)CollectorClient.getTimeout(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to add document " + documentNames[0]), (Throwable)e);
        }
        AddDocumentsResponse response = stubs.addDocuments(request);
        logger.trace((Object)("Number of response wrappers " + response.getAddDocumentResponseWrapper().length));
        String sresponse = null;
        for (int i = 0; i < response.getAddDocumentResponseWrapper().length; ++i) {
            sresponse = response.getAddDocumentResponseWrapper()[i].getResponse().toString();
            logger.trace((Object)("Returned response for " + response.getAddDocumentResponseWrapper()[i].getDocumentName() + ": " + sresponse));
        }
    }

    private static int getTimeout() {
        try {
            return (Integer)ISPublisherContext.getContext().getProperty("COLLECTOR_CHANNEL_TIMEOUT");
        }
        catch (Exception e) {
            return 120000;
        }
    }
}

