/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record;

import gr.uoa.di.madgik.compressedstream.CompressedObjectStream;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.record.GRS2ExceptionWrapper;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class Record
implements IPumpable,
Serializable {
    private static final long serialVersionUID = -1338682225030852571L;
    private int definitionIndex = -1;
    private transient IBuffer buffer = null;
    private long id = -1L;
    private transient Field[] fields = null;
    private boolean defaultField = false;
    private boolean remoteCopy = false;
    private transient IBuffer hiddenBuffer = null;
    private long hiddenId = -1L;
    private int hiddenDefinitionIndex = -1;
    private boolean hasBeenHidden = false;

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public RecordDefinition getDefinition() throws GRS2RecordDefinitionException, GRS2BufferException {
        if (this.buffer == null) {
            throw new GRS2RecordDefinitionException("Record not properly bind to buffer");
        }
        if (this.definitionIndex < 0 || this.definitionIndex >= this.buffer.getRecordDefinitions().length) {
            throw new GRS2RecordDefinitionException("Definition index not properly initialized");
        }
        return this.buffer.getRecordDefinitions()[this.definitionIndex];
    }

    public int getDefinitionIndex() {
        return this.definitionIndex;
    }

    public void setDefinitionIndex(int index) {
        this.definitionIndex = index;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
        this.defaultField = false;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Field getField(String name) throws GRS2RecordDefinitionException, GRS2BufferException {
        int index = this.getDefinition().getDefinition(name);
        if (index < 0 || index >= this.fields.length) {
            return null;
        }
        return this.fields[index];
    }

    public Field getField(int index) {
        if (index < 0 || index >= this.fields.length) {
            return null;
        }
        return this.fields[index];
    }

    public void bind(IBuffer buffer) throws GRS2BufferException, GRS2RecordDefinitionException {
        this.buffer = buffer;
        if (this.definitionIndex < 0 && this.buffer.getRecordDefinitions().length == 1) {
            this.definitionIndex = 0;
        } else if (this.definitionIndex < 0 && this.buffer.getRecordDefinitions().length > 1) {
            throw new GRS2RecordDefinitionException("No definition index defined and default value cannot be infered");
        }
        if (this.definitionIndex < 0 || this.definitionIndex >= this.buffer.getRecordDefinitions().length) {
            throw new GRS2RecordDefinitionException("No definition found for index " + this.definitionIndex);
        }
        this.id = this.buffer.totalRecords() - 1L;
        if (this.fields == null) {
            this.fields = new Field[0];
            this.defaultField = true;
        }
        if (!(this instanceof GRS2ExceptionWrapper)) {
            if (this.getDefinition().getDefinitionSize() != this.fields.length) {
                throw new GRS2RecordDefinitionException("Definition does not match record");
            }
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].setDefinitionIndex(i);
                this.fields[i].bind(this);
            }
        }
        this.hiddenBuffer = this.buffer;
        this.hiddenId = this.id;
        this.hiddenDefinitionIndex = this.definitionIndex;
    }

    public void unbind() {
        this.buffer = null;
        this.id = -1L;
        this.definitionIndex = -1;
        if (this.defaultField) {
            this.fields = null;
            this.defaultField = false;
        }
    }

    public void hide() {
        this.hasBeenHidden = true;
        this.hiddenBuffer = this.buffer;
        this.buffer = null;
        this.hiddenDefinitionIndex = this.definitionIndex;
        this.definitionIndex = -1;
        this.hiddenId = this.id;
        this.id = -1L;
    }

    public void show() {
        this.buffer = this.hiddenBuffer;
        this.definitionIndex = this.hiddenDefinitionIndex;
        this.id = this.hiddenId;
    }

    public boolean isBoundTo(IBuffer buffer) {
        return this.buffer == buffer;
    }

    public void prebind(IBuffer buffer) {
        this.buffer = buffer;
    }

    public void markActivity() {
        this.buffer.markSimulateActivity();
    }

    public void setRemoteCopy(boolean remoteCopy) {
        this.remoteCopy = remoteCopy;
        if (this.fields != null) {
            for (Field f : this.fields) {
                f.setRemoteCopy(remoteCopy);
            }
        }
    }

    public boolean isRemoteCopy() {
        return this.remoteCopy;
    }

    public IBuffer.TransportDirective resolveTransportDirective() throws GRS2RecordDefinitionException, GRS2BufferException {
        RecordDefinition def = this.getDefinition();
        switch (def.getTransportDirective()) {
            case Full: 
            case Partial: {
                return def.getTransportDirective();
            }
            case Inherit: {
                return this.buffer.resolveTransportDirective();
            }
        }
        return IBuffer.TransportDirective.Full;
    }

    @Override
    public final void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeLong(this.id);
            out.writeBoolean(this.remoteCopy);
            this.extendDeflate(out);
            for (Field f : this.fields) {
                out.writeBoolean(true);
                out.writeUTF(f.getClass().getName());
                f.deflate(out);
            }
            out.writeBoolean(false);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to deflate record", e);
        }
    }

    public final void send(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeLong(this.id);
            out.writeBoolean(this.remoteCopy);
            this.extendSend(out);
            for (Field f : this.fields) {
                out.writeBoolean(true);
                out.writeUTF(f.getClass().getName());
                f.send(out);
            }
            out.writeBoolean(false);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public Element sendToXML(Document doc) throws GRS2RecordSerializationException {
        try {
            Element element = doc.createElement("record");
            Element elm = null;
            elm = doc.createElement("definitionIndex");
            elm.setTextContent(String.valueOf(this.getDefinitionIndex()));
            element.appendChild(elm);
            elm = doc.createElement("id");
            elm.setTextContent(String.valueOf(this.getID()));
            element.appendChild(elm);
            elm = doc.createElement("remoteCopy");
            elm.setTextContent(String.valueOf(this.remoteCopy));
            element.appendChild(elm);
            Element fields = doc.createElement("fields");
            for (Field f : this.getFields()) {
                Element fieldEl = f.sendToXML(doc);
                elm = doc.createElement("fieldClassName");
                elm.setTextContent(f.getClass().getName());
                fieldEl.appendChild(elm);
                fields.appendChild(fieldEl);
            }
            element.appendChild(fields);
            return element;
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    @Override
    public final void inflate(DataInput in) throws GRS2RecordSerializationException {
        this.inflate(in, false);
    }

    @Override
    public final void inflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.id = in.readLong();
            this.remoteCopy = in.readBoolean();
            if (reset) {
                this.remoteCopy = false;
            }
            this.extendInflate(in, reset);
            ArrayList<Field> fs = new ArrayList<Field>();
            while (in.readBoolean()) {
                String fieldType = in.readUTF();
                Field f = (Field)Class.forName(fieldType).newInstance();
                f.prebind(this);
                f.inflate(in, reset);
                fs.add(f);
            }
            this.fields = fs.toArray(new Field[0]);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final void receive(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.id = in.readLong();
            this.remoteCopy = in.readBoolean();
            this.extendReceive(in);
            ArrayList<Field> fs = new ArrayList<Field>();
            while (in.readBoolean()) {
                String fieldType = in.readUTF();
                Field f = (Field)Class.forName(fieldType).newInstance();
                f.prebind(this);
                f.receive(in);
                fs.add(f);
            }
            this.fields = fs.toArray(new Field[0]);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final void makeLocal() {
        this.extendMakeLocal();
        for (Field f : this.fields) {
            f.makeLocal();
        }
        this.remoteCopy = false;
    }

    public abstract void extendSend(DataOutput var1) throws GRS2RecordSerializationException;

    public abstract void extendReceive(DataInput var1) throws GRS2RecordSerializationException;

    public abstract void extendDeflate(DataOutput var1) throws GRS2RecordSerializationException;

    public abstract void extendInflate(DataInput var1, boolean var2) throws GRS2RecordSerializationException;

    protected abstract void extendMakeLocal();

    public void dispose() {
        if (this.hasBeenHidden) {
            return;
        }
        this.extendDispose();
        if (this.fields != null) {
            for (Field f : this.fields) {
                f.dispose();
            }
        }
        this.fields = null;
        this.definitionIndex = -1;
        this.buffer = null;
    }

    public abstract void extendDispose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPartial(IBuffer.TransportOverride override, int fieldIndex) throws GRS2ProxyMirrorException {
        Object notify;
        IMirror mirror = this.buffer.getMirror();
        if (mirror == null) {
            return;
        }
        Object object = notify = new Object();
        synchronized (object) {
            long period = mirror.requestPartial(this.id, fieldIndex, override, notify);
            do {
                try {
                    notify.wait(period);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!mirror.pollPartial(this.id, fieldIndex));
        }
    }

    public void makeAvailable() throws GRS2RecordDefinitionException, GRS2ProxyMirrorException, GRS2BufferException {
        for (int i = 0; i < this.fields.length; ++i) {
            this.makeAvailable(i);
        }
    }

    public void makeAvailable(String fieldName) throws GRS2RecordDefinitionException, GRS2ProxyMirrorException, GRS2BufferException {
        this.makeAvailable(IBuffer.TransportOverride.Override, this.getDefinition().getDefinition(fieldName));
    }

    public void makeAvailable(int fieldIndex) throws GRS2RecordDefinitionException, GRS2ProxyMirrorException, GRS2BufferException {
        this.makeAvailable(IBuffer.TransportOverride.Override, fieldIndex);
    }

    private void makeAvailable(IBuffer.TransportOverride override, int fieldIndex) throws GRS2ProxyMirrorException, GRS2RecordDefinitionException, GRS2BufferException {
        if (fieldIndex < 0 || fieldIndex >= this.fields.length) {
            throw new GRS2RecordDefinitionException("Provided field index is not available");
        }
        Field f = this.fields[fieldIndex];
        if (f.isAvailable()) {
            return;
        }
        IBuffer.TransportDirective dir = f.resolveTransportDirective();
        if (dir == IBuffer.TransportDirective.Full) {
            return;
        }
        if (dir == IBuffer.TransportDirective.Inherit) {
            throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
        }
        this.requestPartial(override, fieldIndex);
    }

    @Override
    public final Element toXML(Document doc) throws GRS2RecordSerializationException {
        Element element = doc.createElement("record");
        Element elm = null;
        elm = doc.createElement("definitionIndex");
        elm.setTextContent(String.valueOf(this.getDefinitionIndex()));
        element.appendChild(elm);
        elm = doc.createElement("id");
        elm.setTextContent(String.valueOf(this.getID()));
        element.appendChild(elm);
        elm = doc.createElement("remoteCopy");
        elm.setTextContent(String.valueOf(this.isRemoteCopy()));
        element.appendChild(elm);
        Element fields = doc.createElement("fields");
        for (Field f : this.getFields()) {
            Element fieldEl = f.toXML(doc);
            elm = doc.createElement("fieldClassName");
            elm.setTextContent(f.getClass().getName());
            fieldEl.appendChild(elm);
            fields.appendChild(fieldEl);
        }
        element.appendChild(fields);
        return element;
    }

    public void receiveFromXML(Element element) throws GRS2RecordSerializationException {
        try {
            Integer definitionIndex = Integer.parseInt(element.getElementsByTagName("definitionIndex").item(0).getTextContent());
            this.definitionIndex = definitionIndex;
            Long id = Long.parseLong(element.getElementsByTagName("id").item(0).getTextContent());
            this.id = id;
            Boolean remoteCopy = Boolean.parseBoolean(element.getElementsByTagName("remoteCopy").item(0).getTextContent());
            this.remoteCopy = remoteCopy;
            Element fields = (Element)element.getElementsByTagName("fields").item(0);
            ArrayList<Field> fs = new ArrayList<Field>();
            NodeList fieldList = fields.getChildNodes();
            for (int i = 0; i < fieldList.getLength(); ++i) {
                Field f;
                Element fieldEl = (Element)fieldList.item(i);
                String fieldType = fieldEl.getElementsByTagName("fieldClassName").item(0).getTextContent();
                try {
                    f = (Field)Class.forName(fieldType).newInstance();
                }
                catch (Exception e) {
                    throw new GRS2RecordSerializationException("unable to get record from xml", e);
                }
                f.prebind(this);
                f.receiveFromXML(fieldEl);
                fs.add(f);
            }
            this.fields = fs.toArray(new Field[0]);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    @Override
    public final void fromXML(Element element) throws GRS2RecordSerializationException {
        Integer definitionIndex = Integer.parseInt(element.getElementsByTagName("definitionIndex").item(0).getTextContent());
        this.definitionIndex = definitionIndex;
        Long id = Long.parseLong(element.getElementsByTagName("id").item(0).getTextContent());
        this.id = id;
        Boolean remoteCopy = Boolean.parseBoolean(element.getElementsByTagName("remoteCopy").item(0).getTextContent());
        this.remoteCopy = remoteCopy;
        Element fields = (Element)element.getElementsByTagName("fields").item(0);
        ArrayList<Field> fs = new ArrayList<Field>();
        NodeList fieldList = fields.getChildNodes();
        for (int i = 0; i < fieldList.getLength(); ++i) {
            Field f;
            Element fieldEl = (Element)fieldList.item(i);
            String fieldType = fieldEl.getElementsByTagName("fieldClassName").item(0).getTextContent();
            try {
                f = (Field)Class.forName(fieldType).newInstance();
            }
            catch (Exception e) {
                throw new GRS2RecordSerializationException("unable to get record from xml", e);
            }
            f.prebind(this);
            f.fromXML(fieldEl);
            fs.add(f);
        }
        this.fields = fs.toArray(new Field[0]);
    }

    private void writeObject(ObjectOutputStream out) throws IOException, GRS2RecordDefinitionException, GRS2BufferException {
        this.writeFields(out);
        ArrayList<Field> compressedFields = new ArrayList<Field>();
        ArrayList<Field> uncompressedFields = new ArrayList<Field>();
        for (Field f : this.fields) {
            if (f instanceof FileField) {
                uncompressedFields.add(f);
                continue;
            }
            compressedFields.add(f);
        }
        CompressedObjectStream.writeObject(compressedFields, out);
        out.writeInt(uncompressedFields.size());
        for (Field f : uncompressedFields) {
            IBuffer.TransportOverride over = IBuffer.TransportOverride.Defined;
            ((FileField)f).extendWriteObject(out, over);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int idx;
        this.readFields(in);
        ArrayList compressedFields = (ArrayList)CompressedObjectStream.readObject(in);
        Integer numOfUncompressed = in.readInt();
        this.fields = new Field[compressedFields.size() + numOfUncompressed];
        for (Field f : compressedFields) {
            idx = f.getDefinitionIndex();
            if (idx < 0 || idx > this.fields.length) {
                throw new IOException("Definition index not in range 0, " + this.fields.length);
            }
            if (this.fields[idx] != null) {
                throw new IOException("Definition index has already been used by another field");
            }
            this.fields[idx] = f;
        }
        for (int k = 0; k < numOfUncompressed; ++k) {
            FileField ff = new FileField();
            ff.prebind(this);
            ff.extendReadObject(in, IBuffer.TransportOverride.Defined);
            idx = ff.getDefinitionIndex();
            if (idx < 0 || idx > this.fields.length) {
                throw new IOException("Definition index not in range 0, " + this.fields.length);
            }
            if (this.fields[idx] != null) {
                throw new IOException("Definition index has already been used by another field");
            }
            this.fields[idx] = ff;
        }
    }

    private void writeFields(ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream bfos = new BufferedOutputStream(bos);
        GZIPOutputStream gz = new GZIPOutputStream(bfos);
        ObjectOutputStream oos = new ObjectOutputStream(gz);
        oos.writeObject(this.definitionIndex);
        oos.writeObject(this.id);
        oos.writeObject(this.defaultField);
        oos.writeObject(this.remoteCopy);
        oos.writeObject(this.hiddenId);
        oos.writeObject(this.hiddenDefinitionIndex);
        oos.writeObject(this.hasBeenHidden);
        gz.finish();
        oos.flush();
        byte[] compressed = bos.toByteArray();
        out.writeObject(compressed);
        bos.close();
        bfos.close();
        gz.close();
        oos.close();
    }

    private void readFields(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte[] compressed = (byte[])in.readObject();
        ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
        BufferedInputStream bfis = new BufferedInputStream(bis);
        GZIPInputStream gz = new GZIPInputStream(bfis);
        ObjectInputStream ois = new ObjectInputStream(gz);
        this.definitionIndex = (Integer)ois.readObject();
        this.id = (Long)ois.readObject();
        this.defaultField = (Boolean)ois.readObject();
        this.remoteCopy = (Boolean)ois.readObject();
        this.hiddenId = (Long)ois.readObject();
        this.hiddenDefinitionIndex = (Integer)ois.readObject();
        this.hasBeenHidden = (Boolean)ois.readObject();
        bis.close();
        bfis.close();
        gz.close();
        ois.close();
    }
}

