/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.concurrency;

import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingClusterOperation;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContext;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContextThreadLocal;
import net.sf.ehcache.constructs.nonstop.concurrency.InvalidLockStateAfterRejoinException;
import net.sf.ehcache.constructs.nonstop.concurrency.LockOperationTimedOutNonstopException;
import net.sf.ehcache.constructs.nonstop.concurrency.NonstopThreadUniqueIdProvider;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;

class NonstopSync
implements Sync {
    private final NonstopStore nonstopStore;
    private final ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal;
    private final Object key;
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;

    public NonstopSync(NonstopStore nonstopStore, NonstopActiveDelegateHolder nonstopActiveDelegateHolder, ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal, Object key) {
        this.nonstopStore = nonstopStore;
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.explicitLockingContextThreadLocal = explicitLockingContextThreadLocal;
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean isHeldByCurrentThread(final LockType type) {
        return this.nonstopStore.executeClusterOperation(new ExplicitLockingClusterOperation<Boolean>(){

            @Override
            public Boolean performClusterOperation() {
                return NonstopSync.this.nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(NonstopSync.this.key).isHeldByCurrentThread(type);
            }

            @Override
            public Boolean performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                throw new LockOperationTimedOutNonstopException("isHeldByCurrentThread() timed out");
            }
        });
    }

    public void lock(final LockType type) {
        final ExplicitLockingContext appThreadLockContext = this.explicitLockingContextThreadLocal.getCurrentThreadLockContext();
        this.nonstopStore.executeClusterOperation(new ExplicitLockingClusterOperation<Void>(){

            @Override
            public Void performClusterOperation() {
                NonstopSync.this.nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(NonstopSync.this.key).lock(type);
                appThreadLockContext.lockAcquired(NonstopThreadUniqueIdProvider.getCurrentNonstopThreadUniqueId());
                return null;
            }

            @Override
            public Void performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                throw new LockOperationTimedOutNonstopException("lock() timed out");
            }
        });
    }

    public boolean tryLock(final LockType type, final long msec) throws InterruptedException {
        final ExplicitLockingContext appThreadLockContext = this.explicitLockingContextThreadLocal.getCurrentThreadLockContext();
        return this.nonstopStore.executeClusterOperation(new ExplicitLockingClusterOperation<Boolean>(){

            @Override
            public Boolean performClusterOperation() throws Exception {
                boolean lockAcquired = NonstopSync.this.nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(NonstopSync.this.key).tryLock(type, msec);
                if (lockAcquired) {
                    appThreadLockContext.lockAcquired(NonstopThreadUniqueIdProvider.getCurrentNonstopThreadUniqueId());
                }
                return lockAcquired;
            }

            @Override
            public Boolean performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                throw new LockOperationTimedOutNonstopException("tryLock() timed out");
            }
        });
    }

    public void unlock(final LockType type) {
        final ExplicitLockingContext appThreadLockContext = this.explicitLockingContextThreadLocal.getCurrentThreadLockContext();
        this.nonstopStore.executeClusterOperation(new ExplicitLockingClusterOperation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void performClusterOperation() {
                try {
                    if (appThreadLockContext.areLocksAcquiredByOtherThreads(NonstopThreadUniqueIdProvider.getCurrentNonstopThreadUniqueId())) {
                        throw new InvalidLockStateAfterRejoinException();
                    }
                    NonstopSync.this.nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(NonstopSync.this.key).unlock(type);
                }
                finally {
                    appThreadLockContext.lockReleased();
                }
                return null;
            }

            @Override
            public Void performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                appThreadLockContext.lockReleased();
                throw new LockOperationTimedOutNonstopException("unlock() timed out");
            }
        });
    }
}

