/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.globus.gsi.CertUtil;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSException;

public class ProxyUtil {
    private static Logger logger = Logger.getLogger(ProxyUtil.class);

    public static ExtendedGSSCredential loadProxyCredentials(byte[] credentials) throws GSSException {
        if (credentials == null) {
            throw new NullPointerException("credentials to parse cannot be null");
        }
        ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        ExtendedGSSCredential cred = (ExtendedGSSCredential)manager.createCredential(credentials, 0, 0, null, 0);
        return cred;
    }

    public static ExtendedGSSCredential loadProxyCredentials(String fileName) throws IOException, GSSException {
        if (fileName == null) {
            throw new NullPointerException("credentials file cannot be null");
        }
        File f = new File(fileName);
        byte[] data = new byte[(int)f.length()];
        FileInputStream in = new FileInputStream(f);
        in.read(data);
        in.close();
        return ProxyUtil.loadProxyCredentials(data);
    }

    public static void storeProxyCredentials(String fileName, ExtendedGSSCredential credentials) throws GSSException, IOException {
        if (fileName == null) {
            throw new NullPointerException("Credentials file cannot be null");
        }
        if (credentials == null) {
            throw new NullPointerException("Credentials to be stored cannot be null");
        }
        byte[] data = credentials.export(0);
        FileOutputStream out = new FileOutputStream(fileName);
        out.write(data);
        out.close();
    }

    public static ExtendedGSSCredential getCredentialsFromMyproxy(String myProxyHost, int myProxyPort, String username, String password, int hours) throws MyProxyException {
        if (myProxyHost == null) {
            throw new NullPointerException("The MyProxy host cannot be null");
        }
        if (username == null) {
            throw new NullPointerException("The username cannot be null");
        }
        logger.debug((Object)("Using MyProxy on host " + myProxyHost + " and port " + myProxyPort + " to get credentials for account " + username + " (lifetime " + hours + " hours)"));
        MyProxy myproxy = new MyProxy(myProxyHost, myProxyPort);
        ExtendedGSSCredential delegatedCredentials = null;
        try {
            delegatedCredentials = (ExtendedGSSCredential)myproxy.get(username, password, hours * 3600);
        }
        catch (MyProxyException e) {
            logger.error((Object)("Cannot retrieve credentials from MyProxy at address (host: '" + myProxyHost + "', port: '" + myProxyPort + "') to get delegated credentials for " + username + " with lifetime of " + hours + " hours. "), (Throwable)e);
            throw e;
        }
        if (delegatedCredentials == null) {
            throw new MyProxyException("Null credentials retrieved from MyProxy at address (host: '" + myProxyHost + "', port: '" + myProxyPort + "') to get delegated credentials for " + username + " with lifetime of " + hours + "hours. ");
        }
        return delegatedCredentials;
    }

    public static String getDN(ExtendedGSSCredential credentials) throws Exception {
        if (credentials == null) {
            throw new NullPointerException("Credentials cannot be null");
        }
        X509Certificate[] orderCerts = null;
        try {
            byte[] array = credentials.export(0);
            ByteArrayInputStream byteArray = new ByteArrayInputStream(array);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            X509Certificate c1 = (X509Certificate)cf.generateCertificate(byteArray);
            certs.add(c1);
            logger.debug((Object)("Added certificate to the chain for DN: " + c1.getSubjectDN().getName()));
            int red = -1;
            String keyStr = "";
            while ((red = byteArray.read()) != -1 && !(keyStr = keyStr + (char)red).endsWith("-----END RSA PRIVATE KEY-----")) {
            }
            byteArray.read();
            try {
                while (true) {
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(byteArray);
                    certs.add(cert);
                    logger.debug((Object)("Added certificate to the chain for DN: " + cert.getSubjectDN().getName()));
                }
            }
            catch (Exception e) {
                logger.error((Object)("Certificate chain is composed by " + certs.size() + " certificates\n"));
                orderCerts = ProxyUtil.orderChain(certs.toArray(new X509Certificate[certs.size()]));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot retrieve the DN from credentials", (Throwable)e);
            throw new Exception("Cannot retrieve the DN from credentials", e);
        }
        if (orderCerts != null && orderCerts.length > 0) {
            X500Principal principal = orderCerts[0].getIssuerX500Principal();
            String x500dn = ProxyUtil.getDNOnlineRepresentation(principal.getName());
            return x500dn;
        }
        throw new Exception("The certificate chain is empty, cannot retrieve the DN");
    }

    public static String getCA(ExtendedGSSCredential credentials) throws Exception {
        if (credentials == null) {
            throw new NullPointerException("Credentials cannot be null");
        }
        X509Certificate[] orderCerts = null;
        try {
            byte[] array = credentials.export(0);
            ByteArrayInputStream byteArray = new ByteArrayInputStream(array);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            X509Certificate c1 = (X509Certificate)cf.generateCertificate(byteArray);
            certs.add(c1);
            logger.debug((Object)("Added certificate to the chain for DN: " + c1.getSubjectDN().getName()));
            int red = -1;
            String keyStr = "";
            while ((red = byteArray.read()) != -1 && !(keyStr = keyStr + (char)red).endsWith("-----END RSA PRIVATE KEY-----")) {
            }
            byteArray.read();
            try {
                while (true) {
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(byteArray);
                    certs.add(cert);
                    logger.debug((Object)("Added certificate to the chain for DN: " + cert.getSubjectDN().getName()));
                }
            }
            catch (Exception e) {
                logger.error((Object)("Certificate chain is composed by " + certs.size() + " certificates\n"));
                orderCerts = ProxyUtil.orderChain(certs.toArray(new X509Certificate[certs.size()]));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot retrieve the CA from credentials", (Throwable)e);
            throw new Exception("Cannot retrieve the CA from credentials", e);
        }
        if (orderCerts != null && orderCerts.length > 0) {
            X500Principal principal = orderCerts[0].getIssuerX500Principal();
            String x500ca = ProxyUtil.getDNOnlineRepresentation(principal.getName());
            System.out.println("OLD NAME " + x500ca);
            logger.info((Object)("the root CA for this certificate is " + x500ca));
            return x500ca;
        }
        throw new Exception("The certificate chain is empty, cannot retrieve the CA");
    }

    public static int getEndUserCertificateindex(X509Certificate[] certs) {
        int index = -1;
        for (int i = 0; i < certs.length; ++i) {
            boolean hasIssuer = false;
            for (int k = 0; k < certs.length; ++k) {
                if (i == k || !certs[i].getIssuerX500Principal().equals(certs[k].getSubjectX500Principal())) continue;
                hasIssuer = true;
            }
            if (hasIssuer) continue;
            index = i;
        }
        return index;
    }

    public static X509Certificate[] removeCACertificateFromArray(X509Certificate[] certs) {
        X509Certificate[] resultArray = certs;
        int numCA = 0;
        for (int i = 0; i < certs.length; ++i) {
            if (!certs[i].getIssuerX500Principal().equals(certs[i].getSubjectX500Principal())) continue;
            ++numCA;
        }
        if (numCA > 0) {
            resultArray = new X509Certificate[certs.length - numCA];
            int idx = 0;
            for (int k = 0; k < certs.length; ++k) {
                if (certs[k].getIssuerX500Principal().equals(certs[k].getSubjectX500Principal())) continue;
                resultArray[idx] = certs[k];
                ++idx;
            }
        }
        return resultArray;
    }

    public static X509Certificate[] orderChain(X509Certificate[] certs) throws Exception {
        if (certs.length == 0) {
            return certs;
        }
        certs = ProxyUtil.removeCACertificateFromArray(certs);
        X509Certificate[] orderedArray = new X509Certificate[certs.length];
        int index = ProxyUtil.getEndUserCertificateindex(certs);
        if (index == -1) {
            String msg = "Cannot find rootCertificate in file";
            logger.error((Object)msg);
            throw new Exception(msg);
        }
        if (index > -1) {
            Vector<X509Certificate> tempVector = new Vector<X509Certificate>();
            tempVector.add(certs[index]);
            for (int i = 1; i < certs.length; ++i) {
                for (int k = 0; k < certs.length; ++k) {
                    X509Certificate tempCertificate = (X509Certificate)tempVector.get(i - 1);
                    if (!tempCertificate.getSubjectX500Principal().equals(certs[k].getIssuerX500Principal())) continue;
                    tempVector.add(certs[k]);
                }
            }
            X509Certificate[] tempArray = tempVector.toArray(new X509Certificate[0]);
            orderedArray = new X509Certificate[tempArray.length];
            orderedArray[0] = tempArray[0];
            int idx = 1;
            for (int i = tempArray.length - 1; i >= 1; --i) {
                orderedArray[idx] = tempArray[i];
                ++idx;
            }
        }
        return orderedArray;
    }

    public static ExtendedGSSCredential orderCredentials(ExtendedGSSCredential credentials) throws Exception {
        if (credentials == null) {
            throw new NullPointerException("Credentials cannot be null");
        }
        X509Certificate[] orderedCerts = null;
        ByteArrayOutputStream outupCredentialsStream = new ByteArrayOutputStream();
        try {
            byte[] originalCredentials = credentials.export(0);
            ByteArrayInputStream stream = new ByteArrayInputStream(originalCredentials);
            int red = -1;
            String keyStr = "";
            while ((red = stream.read()) != -1) {
                outupCredentialsStream.write(red);
                if (!(keyStr = keyStr + (char)red).endsWith("-----END RSA PRIVATE KEY-----\n")) continue;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            try {
                while (true) {
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(stream);
                    certs.add(cert);
                    logger.debug((Object)("Added certificate to the chain for DN: " + cert.getSubjectDN().getName()));
                }
            }
            catch (Exception e) {
                int i;
                logger.error((Object)("Certificate chain is composed by " + (certs.size() + 1) + " certificates\n"));
                X509Certificate[] tempCerts = ProxyUtil.orderChain(certs.toArray(new X509Certificate[certs.size()]));
                orderedCerts = new X509Certificate[tempCerts.length];
                if (orderedCerts.length > 0) {
                    orderedCerts[orderedCerts.length - 1] = tempCerts[0];
                    for (int i2 = 1; i2 < tempCerts.length; ++i2) {
                        orderedCerts[i2 - 1] = tempCerts[i2];
                    }
                }
                String orderedDNStr = "";
                for (i = 0; i < orderedCerts.length; ++i) {
                    orderedDNStr = orderedDNStr + orderedCerts[i].getSubjectDN().getName() + "\n";
                }
                logger.debug((Object)("The ordered certificate chain (without the last delegated certificate) is composed by:\n" + orderedDNStr));
                for (i = 0; i < orderedCerts.length; ++i) {
                    CertUtil.writeCertificate((OutputStream)outupCredentialsStream, (X509Certificate)orderedCerts[i]);
                }
                byte[] orderedCredentials = outupCredentialsStream.toByteArray();
                return ProxyUtil.loadProxyCredentials(orderedCredentials);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot order the certificate chain", (Throwable)e);
            throw new Exception("Cannot order the certificate chain", e);
        }
    }

    public static String getDNOnlineRepresentation(String rfc2253Format) {
        String[] fields = rfc2253Format.split(",");
        StringBuilder response = new StringBuilder();
        for (int i = fields.length - 1; i >= 0; --i) {
            response.append('/').append(fields[i].trim());
        }
        return response.toString();
    }
}

