/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.kxml.GCUBEResourceImpl;
import org.gcube.common.resources.kxml.utils.KStringList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class KGCUBEResource {
    public static final String NS = null;
    static final DateFormat dateAndTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final String SCHEMA_RESOURCE_LOCATION = "/org/gcube/common/resources/kxml/schemas/";
    protected static final GCUBELog logger = new GCUBELog(KGCUBEResource.class, "Resource Parser");
    protected static Map<Class<? extends GCUBEResourceImpl>, Schema> schemaMap = new HashMap<Class<? extends GCUBEResourceImpl>, Schema>();
    protected static final SchemaFactory sfactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    protected static DOMImplementationLS domImplementation;

    public static <T extends GCUBEResource> void load(T component, Reader reader) throws Exception {
        block13: {
            try {
                int count;
                StringWriter writer = new StringWriter();
                char[] chars = new char[1000];
                while ((count = reader.read(chars)) != -1) {
                    ((Writer)writer).write(chars, 0, count);
                }
                KGCUBEResource.validate(new BufferedReader(new StringReader(((Object)writer).toString())), KGCUBEResource.getSchema((GCUBEResourceImpl)((Object)component)));
                KXmlParser parser = new KXmlParser();
                parser.setInput((Reader)new BufferedReader(new StringReader(((Object)writer).toString())));
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            String id;
                            if (parser.getName().equals("Resource") && parser.getAttributeValue(NS, "version") != null) {
                                component.setResourceVersion(parser.getAttributeValue(NS, "version"));
                            }
                            if (parser.getName().equals("ID") && (id = parser.nextText()) != null && id.length() > 0) {
                                component.setID(id);
                            }
                            if (parser.getName().equals("Scopes")) {
                                ArrayList<GCUBEScope> scopes = new ArrayList<GCUBEScope>();
                                for (String s : KStringList.load("Scopes", parser)) {
                                    scopes.add(GCUBEScope.getScope(s));
                                }
                                component.addScope(scopes.toArray(new GCUBEScope[0]));
                            }
                            if (parser.getName().equals("Profile")) {
                                ((GCUBEResourceImpl)((Object)component)).load(parser);
                            }
                            break;
                        }
                        case 1: {
                            break block13;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Could not load resource from its serialisation", e);
            }
        }
    }

    public static <T extends GCUBEResource> void store(T component, Writer writer) throws Exception {
        StringWriter tempWriter = new StringWriter();
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput((Writer)tempWriter);
        try {
            String line;
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(NS, "Resource");
            serializer.attribute(NS, "version", component.getResourceVersion());
            if (component.getID() != null) {
                serializer.startTag(NS, "ID").text(component.getID()).endTag(NS, "ID");
            }
            if (component.getType() != null) {
                serializer.startTag(NS, "Type").text(component.getType()).endTag(NS, "Type");
            }
            if (component.getScopes().size() != 0) {
                KStringList.store("Scopes", "Scope", new ArrayList<String>(component.getScopes().keySet()), serializer);
            }
            ((GCUBEResourceImpl)((Object)component)).store(serializer);
            serializer.endTag(NS, "Resource");
            serializer.endDocument();
            KGCUBEResource.validate(new BufferedReader(new StringReader(tempWriter.toString())), KGCUBEResource.getSchema((GCUBEResourceImpl)((Object)component)));
            BufferedReader serialisationReader = new BufferedReader(new StringReader(tempWriter.toString()));
            while ((line = serialisationReader.readLine()) != null) {
                writer.write(line);
            }
            serialisationReader.close();
        }
        catch (Exception e) {
            throw new Exception("The resource does not have a valid serialisation", e);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized Schema getSchema(GCUBEResourceImpl component) throws Exception {
        sfactory.setResourceResolver(new SchemaResolver());
        Schema schema = schemaMap.get(component.getClass());
        if (schema == null) {
            if (domImplementation == null) {
                domImplementation = (DOMImplementationLS)((Object)DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation());
            }
            SchemaFactory schemaFactory = sfactory;
            synchronized (schemaFactory) {
                schema = sfactory.newSchema(new StreamSource(component.getSchemaResource()));
                schemaMap.put(component.getClass(), schema);
            }
        }
        return schema;
    }

    protected static void validate(Reader reader, Schema schema) throws Exception {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        ((SAXParserFactory)factory).setSchema(schema);
        ((SAXParserFactory)factory).setNamespaceAware(true);
        XMLReader xmlReader = ((SAXParserFactory)factory).newSAXParser().getXMLReader();
        final BooleanWrapper wrapper = new BooleanWrapper();
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void error(SAXParseException e) {
                this.fatalError(e);
            }

            @Override
            public void fatalError(SAXParseException e) {
                wrapper.valid = false;
                wrapper.exception = new Exception("Line:" + e.getLineNumber() + ":" + e.getMessage() + "\n");
            }
        };
        xmlReader.setErrorHandler(handler);
        xmlReader.parse(new InputSource(reader));
        if (!wrapper.valid) {
            throw wrapper.exception;
        }
    }

    private static DateFormat getDateAndTime() {
        return dateAndTime;
    }

    public static synchronized String toXMLDateAndTime(Date date) {
        String formatted = KGCUBEResource.getDateAndTime().format(date);
        StringBuilder toXS = new StringBuilder();
        toXS.append(formatted.substring(0, formatted.length() - 2));
        toXS.append(":");
        toXS.append(formatted.substring(formatted.length() - 2, formatted.length()));
        return toXS.toString();
    }

    public static synchronized Date fromXMLDateAndTime(String date) throws ParseException {
        Pattern p = Pattern.compile("^.*T\\d{2}:\\d{2}:\\d{2}$");
        if (p.matcher(date).matches()) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(date);
        }
        StringBuilder toDate = new StringBuilder();
        toDate.append(date.substring(0, date.length() - 3));
        toDate.append(date.substring(date.length() - 2, date.length()));
        return KGCUBEResource.getDateAndTime().parse(toDate.toString());
    }

    protected static class SchemaResolver
    implements LSResourceResolver {
        protected SchemaResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LSInput source = null;
            if (systemId.equals("CommonTypeDefinitions.xsd")) {
                source = domImplementation.createLSInput();
                source.setByteStream(KGCUBEResource.class.getResourceAsStream("/org/gcube/common/resources/kxml/schemas/CommonTypeDefinitions.xsd"));
            }
            return source;
        }
    }

    static class BooleanWrapper {
        boolean valid = true;
        Exception exception;

        BooleanWrapper() {
        }
    }
}

