/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.notification.impl.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.notification.impl.EPR;
import org.gcube.common.informationsystem.notification.impl.client.ISNotificationManager;
import org.gcube.common.informationsystem.notification.impl.client.ReNotifier;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.container.ContainerException;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.impl.notification.ClientNotificationConsumerManager;
import org.globus.wsrf.impl.notification.ServerNotificationConsumerManager;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationBroker
implements NotifyCallback {
    private GCUBELog logger = new GCUBELog(NotificationBroker.class);
    protected static final GCUBELog log = new GCUBELog(NotificationBroker.class);
    private NotificationConsumerManager consumerManager;
    private EndpointReferenceType myEpr;
    private Map<QName, ISNotifier.BaseNotificationConsumer> subscriber = Collections.synchronizedMap(new HashMap());
    protected List<ISNotifier.GCUBENotificationTopic> relatedTopic = null;
    protected GCUBEProducer<ISNotifier.NotificationTopic, ISNotifier.NotificationMessage> producer;
    private Map<QName, Set<EPR>> knownProducers = Collections.synchronizedMap(new HashMap());

    protected NotificationBroker() throws Exception {
        try {
            this.relatedTopic = new ArrayList<ISNotifier.GCUBENotificationTopic>();
            log.trace((Object)"Getting a notification consumerManager manager instance...");
            if (!GHNContext.getContext().isClientMode()) {
                this.logger.debug((Object)"the GHN is server mode");
                this.consumerManager = new ServerNotificationConsumerManager();
            } else {
                this.logger.debug((Object)"the GHN is client mode");
                this.consumerManager = new ClientNotificationConsumerManager();
            }
            this.consumerManager.startListening();
            this.myEpr = this.consumerManager.createNotificationConsumer((NotifyCallback)this);
            log.trace((Object)("instanciated the NotificationBroker with epr  " + this.myEpr));
            this.producer = new GCUBEProducer();
            log.info((Object)("Notification Broker is ready for action with epr " + this.myEpr));
        }
        catch (Exception exception) {
            log.fatal((Object)"Error while initializing the Notification subscriber!", (Throwable)exception);
            throw exception;
        }
    }

    public void subscribeForAnyTopic(ISNotifier.BaseNotificationConsumer baseNotificationConsumer, ISNotifier.GCUBENotificationTopic gCUBENotificationTopic, GCUBESecurityManager gCUBESecurityManager, GCUBEScope gCUBEScope) {
        log.debug((Object)"subscribe for any topic");
        try {
            EndpointReferenceType[] endpointReferenceTypeArray;
            Object object;
            this.relatedTopic.add(gCUBENotificationTopic);
            ISNotifier.BaseNotificationConsumer baseNotificationConsumer2 = this.subscriber.get(gCUBENotificationTopic);
            if (baseNotificationConsumer2 == null) {
                this.subscriber.put(gCUBENotificationTopic.getTopicQName(), baseNotificationConsumer);
                log.trace((Object)("Subscribing to IS about topic " + gCUBENotificationTopic));
                object = new ISNotificationManager(gCUBEScope);
                endpointReferenceTypeArray = ((ISNotificationManager)object).subscribeEPRToTopic(this.myEpr, gCUBENotificationTopic, gCUBESecurityManager);
                if (endpointReferenceTypeArray == null) {
                    endpointReferenceTypeArray = new EndpointReferenceType[]{};
                }
                for (int i = 0; i < endpointReferenceTypeArray.length; ++i) {
                    this.insertKnownProducer(gCUBENotificationTopic.getTopicQName(), endpointReferenceTypeArray[i]);
                }
            }
            if (gCUBENotificationTopic.isUseRenotifier()) {
                object = this.getProducers(gCUBENotificationTopic.getTopicQName());
                endpointReferenceTypeArray = object.iterator();
                while (endpointReferenceTypeArray.hasNext()) {
                    EndpointReferenceType endpointReferenceType = endpointReferenceTypeArray.next();
                    ReNotifier reNotifier = new ReNotifier(gCUBENotificationTopic, endpointReferenceType, gCUBEScope, this);
                    new Thread(reNotifier).start();
                }
            }
            baseNotificationConsumer.notifications.add(gCUBENotificationTopic.getTopicQName());
            this.producer.subscribe((GCUBEConsumer)baseNotificationConsumer, (GCUBETopic[])new ISNotifier.NotificationTopic[]{ISNotifier.NotificationTopic.NOTIFICATIONRECEIVED});
            log.trace((Object)"the subscription is done");
        }
        catch (Exception exception) {
            log.warn((Object)"error in subscribe for any topic", (Throwable)exception);
        }
    }

    public void unsubscribeFromAnyTopic(ISNotifier.GCUBENotificationTopic gCUBENotificationTopic, GCUBESecurityManager gCUBESecurityManager, GCUBEScope gCUBEScope) {
        ISNotifier.BaseNotificationConsumer baseNotificationConsumer = this.getSubscribers(gCUBENotificationTopic.getTopicQName());
        if (baseNotificationConsumer == null) {
            return;
        }
        log.trace((Object)("Unsubscribing client from topic " + gCUBENotificationTopic));
        log.trace((Object)("unregistering topic is successfull? " + this.relatedTopic.remove(gCUBENotificationTopic)));
        if (baseNotificationConsumer.notifications.contains(gCUBENotificationTopic.getTopicQName())) {
            log.trace((Object)("the consumer contains the topic, has been removed ?" + baseNotificationConsumer.notifications.remove(gCUBENotificationTopic.getTopicQName())));
            if (baseNotificationConsumer.notifications.size() == 0) {
                this.producer.unsubscribe((GCUBEConsumer)baseNotificationConsumer, (GCUBETopic[])new ISNotifier.NotificationTopic[]{ISNotifier.NotificationTopic.NOTIFICATIONRECEIVED});
                log.trace((Object)"the notification size of the consumer is 0 so we can unsubscrive it");
            }
        }
        this.subscriber.remove(gCUBENotificationTopic);
        try {
            ISNotificationManager iSNotificationManager = new ISNotificationManager(gCUBEScope);
            iSNotificationManager.unsubscribeEPRFromTopic(this.myEpr, gCUBENotificationTopic, gCUBESecurityManager);
        }
        catch (Exception exception) {
            log.warn((Object)("some error occurrs on topic unregistration" + exception.getMessage()));
        }
    }

    private Set<EPR> getProducers(QName qName) {
        Set<EPR> set = this.knownProducers.get(qName);
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private ISNotifier.BaseNotificationConsumer getSubscribers(QName qName) {
        ISNotifier.BaseNotificationConsumer baseNotificationConsumer = this.subscriber.get(qName);
        if (baseNotificationConsumer != null) {
            return baseNotificationConsumer;
        }
        return baseNotificationConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertKnownProducer(QName qName, EndpointReferenceType endpointReferenceType) {
        Map<QName, Set<EPR>> map = this.knownProducers;
        synchronized (map) {
            EPR ePR;
            Set<EPR> set = this.knownProducers.get(qName);
            if (set == null) {
                set = Collections.synchronizedSet(new HashSet());
                this.knownProducers.put(qName, set);
            }
            if (set.contains(ePR = new EPR(endpointReferenceType))) {
                return;
            }
            set.add(ePR);
        }
        log.trace((Object)("Inserted a new known producer for topic " + qName + " at " + endpointReferenceType.getAddress()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKnownProducer(QName qName, EndpointReferenceType endpointReferenceType) {
        Map<QName, Set<EPR>> map = this.knownProducers;
        synchronized (map) {
            Set<EPR> set = this.knownProducers.get(qName);
            if (set == null) {
                log.warn((Object)("Unexpected condition while removing producer for " + qName + " - producer list for topic was null!"));
                return;
            }
            set.remove(new EPR(endpointReferenceType));
            log.trace((Object)("Removed producer at " + endpointReferenceType.getAddress() + " for topic " + qName + " from known producers list."));
            if (set.isEmpty()) {
                log.trace((Object)("No more known producers for topic " + qName + ", removing the list"));
                this.knownProducers.remove(set);
            }
        }
    }

    public void deliver(List list, EndpointReferenceType endpointReferenceType, Object object) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ResourcePropertyValueChangeNotificationType resourcePropertyValueChangeNotificationType;
                QName qName = (QName)iterator.next();
                log.debug((Object)("Received a new notification from " + endpointReferenceType.getAddress() + " about topic " + qName));
                try {
                    ResourcePropertyValueChangeNotificationElementType resourcePropertyValueChangeNotificationElementType = (ResourcePropertyValueChangeNotificationElementType)object;
                    resourcePropertyValueChangeNotificationType = resourcePropertyValueChangeNotificationElementType.getResourcePropertyValueChangeNotification();
                    if (resourcePropertyValueChangeNotificationType == null) continue;
                    MessageElement[] messageElementArray = resourcePropertyValueChangeNotificationType.getNewValue().get_any();
                    ISNotifier.NotificationEvent notificationEvent = new ISNotifier.NotificationEvent(new ISNotifier.NotificationMessage(qName, messageElementArray, endpointReferenceType));
                    this.producer.notify((GCUBETopic)ISNotifier.NotificationTopic.NOTIFICATIONRECEIVED, new GCUBEEvent[]{notificationEvent});
                }
                catch (ClassCastException classCastException) {
                    log.info((Object)"Generic Notfication received");
                    resourcePropertyValueChangeNotificationType = new ISNotifier.NotificationEvent(new ISNotifier.NotificationMessage(qName, object, endpointReferenceType));
                    this.producer.notify((GCUBETopic)ISNotifier.NotificationTopic.NOTIFICATIONRECEIVED, new GCUBEEvent[]{resourcePropertyValueChangeNotificationType});
                }
            }
            catch (Exception exception) {
                log.error((Object)"Exception while receiving notification message!", (Throwable)exception);
            }
        }
    }

    public static String getStringAtIndex(int n, MessageElement[] messageElementArray) {
        return messageElementArray[n].getValue();
    }

    public static String getLastString(MessageElement[] messageElementArray) {
        if (messageElementArray == null || messageElementArray.length < 1) {
            return null;
        }
        return NotificationBroker.getStringAtIndex(messageElementArray.length - 1, messageElementArray);
    }

    public static String getFirstString(MessageElement[] messageElementArray) {
        if (messageElementArray == null || messageElementArray.length < 1) {
            return null;
        }
        return NotificationBroker.getStringAtIndex(0, messageElementArray);
    }

    public static String[] getStringArray(MessageElement[] messageElementArray) {
        if (messageElementArray == null || messageElementArray.length < 1) {
            return new String[0];
        }
        String[] stringArray = new String[messageElementArray.length];
        for (int i = 0; i < messageElementArray.length; ++i) {
            stringArray[i] = NotificationBroker.getStringAtIndex(i, messageElementArray);
        }
        return stringArray;
    }

    protected boolean containsTopic(QName qName) {
        for (ISNotifier.GCUBENotificationTopic gCUBENotificationTopic : this.relatedTopic) {
            if (gCUBENotificationTopic.getTopicQName().toString().compareTo(qName.toString()) != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean containsTopic(ISNotifier.GCUBENotificationTopic gCUBENotificationTopic) {
        return this.relatedTopic.contains(gCUBENotificationTopic);
    }

    protected void stopListening() {
        try {
            this.consumerManager.stopListening();
        }
        catch (ContainerException containerException) {
            log.warn((Object)"impossible to stop receiver", (Throwable)containerException);
        }
    }
}

