/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.utils.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InheritableTLSSLSocketFactory
extends SSLSocketFactory {
    private static SSLSocketFactory defaultSSLSocketFactory;
    private static InheritableTLSSLSocketFactory instance;
    private InheritableThreadLocal<SSLSocketFactory> socketFactoryes;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private InheritableTLSSLSocketFactory() {
        this.socketFactoryes = new InheritableThreadLocal();
    }

    public static InheritableTLSSLSocketFactory getInstance() {
        if (instance == null) {
            defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            instance = new InheritableTLSSLSocketFactory();
        }
        return instance;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.logger.debug("Setting ssl socket factory for thread " + Thread.currentThread().getId());
        this.socketFactoryes.set(sslSocketFactory);
    }

    public void reset() {
        this.logger.debug("Resetting ssl socket factory for thread " + Thread.currentThread().getId());
        this.socketFactoryes.remove();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.getCurrentSSLSocketFactory().createSocket(s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.getCurrentSSLSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.getCurrentSSLSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getCurrentSSLSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.getCurrentSSLSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(String address, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.getCurrentSSLSocketFactory().createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.getCurrentSSLSocketFactory().createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.getCurrentSSLSocketFactory().createSocket();
    }

    public SSLSocketFactory getCurrentSSLSocketFactory() {
        SSLSocketFactory response = (SSLSocketFactory)this.socketFactoryes.get();
        if (response == null) {
            this.logger.debug("No socket factory found for " + Thread.currentThread().getId() + ", using default one");
            response = defaultSSLSocketFactory;
        }
        return response;
    }
}

