/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;

public class FixedObjectInputStream
extends ObjectInputStream {
    public FixedObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        ClassLoader loader = FixedObjectInputStream.class.getClassLoader();
        return Class.forName(v.getName(), false, loader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader loader = FixedObjectInputStream.class.getClassLoader();
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = Class.forName(interfaces[i], false, loader);
        }
        try {
            return Proxy.getProxyClass(loader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

