/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators;

import java.util.HashSet;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.operators.DeployerOperator;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.Converter;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackageFactory;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UndeployParameters;

public class UndeployerOperator
extends GCUBEHandler<DeployerResource> {
    protected final GCUBELog logger = new GCUBELog(UndeployerOperator.class);
    private boolean rollback = false;
    private Set<GCUBEScope> undeployScope = new HashSet<GCUBEScope>();
    private PackageInfo[] packages = null;
    private String callbackID;
    private EndpointReferenceType epr;
    private boolean cleanState = false;

    public UndeployerOperator(UndeployParameters params) {
        for (String scope : params.getTargetScope()) {
            this.undeployScope.add(GCUBEScope.getScope((String)scope));
        }
        this.packages = params.get_package();
        this.callbackID = params.getCallbackID() == null || params.getCallbackID().trim() == "" ? "DEFAULT" : params.getCallbackID();
        this.epr = params.getEndpointReference();
        this.cleanState = params.isCleanState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        this.logger.debug((Object)(Thread.currentThread().getId() + ": doing"));
        this.logger.trace((Object)"Locking the Deployer Operator...");
        DeployerOperator.deployLock.lock();
        ((DeployerResource)((Object)this.getHandled())).setLastDeployment(this.callbackID);
        Report finalreport = this.initialiseReport(this.packages);
        this.logger.trace((Object)"Looping on the packages to undeploy...");
        boolean restart = false;
        for (int i = 0; i < this.packages.length; ++i) {
            try {
                BaseTypedPackage base = ((DeployerResource)((Object)this.getHandled())).getPackage(Converter.toBasePackage(this.packages[i]).getKey());
                this.logger.debug((Object)("Checking package " + base.getKey() + " for undeployment"));
                if (((DeployerResource)((Object)this.getHandled())).isUndeployable(base, this.undeployScope)) {
                    UndeployablePackage undeployablePackage = UndeployablePackageFactory.makeUndeployable(base);
                    PlatformDescription packagePlatform = undeployablePackage.getTargetPlatform();
                    if (packagePlatform == null || packagePlatform.getName().equalsIgnoreCase("gCore")) {
                        this.logger.info((Object)("The package " + undeployablePackage.getKey() + " is going to be undeployed"));
                        undeployablePackage.undeploy(this.undeployScope, this.cleanState);
                        if (undeployablePackage.verify()) {
                            finalreport.addPackage(this.packages[i], Report.PACKAGESTATUS.UNDEPLOYED, i, new String[0]);
                            this.logger.info((Object)("The package " + this.packages[i].getName() + " has been successfully undeployed"));
                        } else {
                            finalreport.addPackage(this.packages[i], Report.PACKAGESTATUS.NOTVERIFIED, i, new String[0]);
                            this.logger.info((Object)("The package " + this.packages[i].getName() + " has been successfully undeployed, but not verified"));
                        }
                        ((DeployerResource)((Object)this.getHandled())).removePackage(undeployablePackage);
                    } else {
                        try {
                            undeployablePackage.undeploy(this.undeployScope, this.cleanState);
                            finalreport.addPackage(this.packages[i], Report.PACKAGESTATUS.UNDEPLOYED, i, new String[0]);
                            this.logger.info((Object)("The package " + this.packages[i].getName() + " has been successfully undeployed"));
                        }
                        finally {
                            ((DeployerResource)((Object)this.getHandled())).removePackage(undeployablePackage);
                        }
                    }
                    if (!undeployablePackage.requireRestart()) continue;
                    restart = true;
                    continue;
                }
                this.logger.info((Object)("The package " + this.packages[i].getName() + " cannot be undeployed"));
                base.removeScopes(this.undeployScope);
                this.logger.info((Object)("The package has been removed from the target undeployment scope(s) " + this.undeployScope));
                finalreport.addPackage(this.packages[i], Report.PACKAGESTATUS.REMOVEDFROMSCOPE, i, "the package has been only removed from the scope, but it cannot be undeployed because of it is shared with other scopes");
                continue;
            }
            catch (DeployerResource.NoSuchPackageException e) {
                this.logger.warn((Object)("the package " + this.packages[i].getName() + " cannot be undeployed: " + e.getMessage()));
                finalreport.addPackage(this.packages[i], Report.PACKAGESTATUS.NOTUNDEPLOYABLE, i, e.getMessage() != null ? e.getMessage() : "NA");
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("An error occurs while undeploying the package " + this.packages[i].getName()), (Throwable)e);
                finalreport.addPackage(this.packages[i], Report.PACKAGESTATUS.FAILED, i, e.getMessage() != null ? e.getMessage() : "NA");
            }
        }
        if (this.rollback) {
            this.rollback();
        }
        try {
            ((DeployerResource)((Object)this.getHandled())).store();
            if (restart) {
                finalreport.send();
                finalreport.save();
                GHNContext.getContext().restart(new String[0]);
            } else {
                finalreport.close();
                finalreport.send();
                finalreport.save();
            }
        }
        finally {
            DeployerOperator.deployLock.unlock();
        }
    }

    private void rollback() {
    }

    private Report initialiseReport(PackageInfo[] packages) {
        Report finalreport = this.undeployScope.size() > 0 ? new Report(this.epr, this.callbackID, packages.length, Report.TYPE.UNDEPLOY, this.undeployScope.iterator().next()) : new Report(this.epr, this.callbackID, packages.length, Report.TYPE.UNDEPLOY, null);
        ((DeployerResource)((Object)this.getHandled())).setLastDeployment(this.callbackID);
        for (int i = 0; i < packages.length; ++i) {
            PackageInfo deployable_package = packages[i];
            finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.WAITING, i, new String[0]);
        }
        return finalreport;
    }
}

