/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.undeployment;

import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.platforms.Finder;
import org.gcube.common.vremanagement.deployer.impl.platforms.PlatformApplication;
import org.gcube.common.vremanagement.deployer.impl.platforms.PlatformCall;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;

public class UndeployablePlatformApplication
extends UndeployablePackage {
    private static final long serialVersionUID = 8732422046795178831L;

    public UndeployablePlatformApplication(BaseTypedPackage base) {
        super(base);
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        return true;
    }

    @Override
    public boolean requireRestart() {
        return false;
    }

    @Override
    protected void packageUndeploy(Set<GCUBEScope> scopes, boolean cleanState) throws DeployException, InvalidPackageArchiveException {
        PlatformApplication app = null;
        PlatformDescription packagePlatform = this.getTargetPlatform();
        if (packagePlatform == null) {
            throw new DeployException("The package cannot be undeployed, there are no platform information");
        }
        try {
            VirtualPlatform platform = Finder.find(packagePlatform);
            this.logger.debug((Object)("Virtual Platform " + packagePlatform.toString() + " is avaliable"));
            app = new PlatformCall(platform).deactivateAndUndeploy(this);
        }
        catch (Finder.PlatformNotAvailableException e) {
            this.logger.error((Object)"No platform is available for this package");
            throw new DeployException("No platform is available for this package");
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to undeploy", (Throwable)e);
            throw new DeployException(e.getMessage());
        }
        try {
            if (app != null) {
                GHNContext.getContext().getLocalInstanceContext().unregisterInstance(app.unpublish(scopes, (GCUBESecurityManager)ServiceContext.getContext()));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to unpublish", (Throwable)e);
        }
    }
}

