/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.apache.naming.resources.RecyclableNamingEnumeration;

public class ResourceAttributes
implements Attributes {
    public static final String CREATION_DATE = "creationdate";
    public static final String ALTERNATE_CREATION_DATE = "creation-date";
    public static final String LAST_MODIFIED = "getlastmodified";
    public static final String ALTERNATE_LAST_MODIFIED = "last-modified";
    public static final String NAME = "displayname";
    public static final String TYPE = "resourcetype";
    public static final String ALTERNATE_TYPE = "content-type";
    public static final String SOURCE = "source";
    public static final String CONTENT_TYPE = "getcontenttype";
    public static final String CONTENT_LANGUAGE = "getcontentlanguage";
    public static final String CONTENT_LENGTH = "getcontentlength";
    public static final String ALTERNATE_CONTENT_LENGTH = "content-length";
    public static final String ETAG = "getetag";
    public static final String COLLECTION_TYPE = "<collection/>";
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected boolean collection = false;
    protected long contentLength = -1L;
    protected long creation = -1L;
    protected Date creationDate = null;
    protected long lastModified = -1L;
    protected Date lastModifiedDate = null;
    protected String lastModifiedHttp = null;
    protected String mimeType = null;
    protected String name = null;
    protected String weakETag = null;
    protected String strongETag = null;
    protected Attributes attributes = null;

    public ResourceAttributes() {
    }

    public ResourceAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean isCollection() {
        if (this.attributes != null) {
            return this.getResourceType().equals(COLLECTION_TYPE);
        }
        return this.collection;
    }

    public void setCollection(boolean bl) {
        this.collection = bl;
        if (this.attributes != null) {
            String string = "";
            if (bl) {
                string = COLLECTION_TYPE;
            }
            this.attributes.put(TYPE, string);
        }
    }

    public long getContentLength() {
        Attribute attribute;
        if (this.contentLength != -1L) {
            return this.contentLength;
        }
        if (this.attributes != null && (attribute = this.attributes.get(CONTENT_LENGTH)) != null) {
            try {
                Object object = attribute.get();
                if (object instanceof Long) {
                    this.contentLength = (Long)object;
                } else {
                    try {
                        this.contentLength = Long.parseLong(object.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.contentLength;
    }

    public void setContentLength(long l) {
        this.contentLength = l;
        if (this.attributes != null) {
            this.attributes.put(CONTENT_LENGTH, new Long(l));
        }
    }

    public long getCreation() {
        block11: {
            Attribute attribute;
            if (this.creation != -1L) {
                return this.creation;
            }
            if (this.creationDate != null) {
                return this.creationDate.getTime();
            }
            if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
                try {
                    Object object = attribute.get();
                    if (object instanceof Long) {
                        this.creation = (Long)object;
                        break block11;
                    }
                    if (object instanceof Date) {
                        this.creation = ((Date)object).getTime();
                        this.creationDate = (Date)object;
                        break block11;
                    }
                    String string = object.toString();
                    Date date = null;
                    int n = 0;
                    while (date == null && n < formats.length) {
                        try {
                            date = formats[n].parse(string);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        ++n;
                    }
                    if (date != null) {
                        this.creation = date.getTime();
                        this.creationDate = date;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.creation;
    }

    public void setCreation(long l) {
        this.creation = l;
        this.creationDate = null;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, new Date(l));
        }
    }

    public Date getCreationDate() {
        block11: {
            Attribute attribute;
            if (this.creationDate != null) {
                return this.creationDate;
            }
            if (this.creation != -1L) {
                this.creationDate = new Date(this.creation);
                return this.creationDate;
            }
            if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
                try {
                    Object object = attribute.get();
                    if (object instanceof Long) {
                        this.creation = (Long)object;
                        this.creationDate = new Date(this.creation);
                        break block11;
                    }
                    if (object instanceof Date) {
                        this.creation = ((Date)object).getTime();
                        this.creationDate = (Date)object;
                        break block11;
                    }
                    String string = object.toString();
                    Date date = null;
                    int n = 0;
                    while (date == null && n < formats.length) {
                        try {
                            date = formats[n].parse(string);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        ++n;
                    }
                    if (date != null) {
                        this.creation = date.getTime();
                        this.creationDate = date;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creation = date.getTime();
        this.creationDate = date;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, date);
        }
    }

    public long getLastModified() {
        block11: {
            Attribute attribute;
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            if (this.lastModifiedDate != null) {
                return this.lastModifiedDate.getTime();
            }
            if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
                try {
                    Object object = attribute.get();
                    if (object instanceof Long) {
                        this.lastModified = (Long)object;
                        break block11;
                    }
                    if (object instanceof Date) {
                        this.lastModified = ((Date)object).getTime();
                        this.lastModifiedDate = (Date)object;
                        break block11;
                    }
                    String string = object.toString();
                    Date date = null;
                    int n = 0;
                    while (date == null && n < formats.length) {
                        try {
                            date = formats[n].parse(string);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        ++n;
                    }
                    if (date != null) {
                        this.lastModified = date.getTime();
                        this.lastModifiedDate = date;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.lastModified;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
        this.lastModifiedDate = null;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, new Date(l));
        }
    }

    public void setLastModified(Date date) {
        this.setLastModifiedDate(date);
    }

    public Date getLastModifiedDate() {
        block11: {
            Attribute attribute;
            if (this.lastModifiedDate != null) {
                return this.lastModifiedDate;
            }
            if (this.lastModified != -1L) {
                this.lastModifiedDate = new Date(this.lastModified);
                return this.lastModifiedDate;
            }
            if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
                try {
                    Object object = attribute.get();
                    if (object instanceof Long) {
                        this.lastModified = (Long)object;
                        this.lastModifiedDate = new Date(this.lastModified);
                        break block11;
                    }
                    if (object instanceof Date) {
                        this.lastModified = ((Date)object).getTime();
                        this.lastModifiedDate = (Date)object;
                        break block11;
                    }
                    String string = object.toString();
                    Date date = null;
                    int n = 0;
                    while (date == null && n < formats.length) {
                        try {
                            date = formats[n].parse(string);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        ++n;
                    }
                    if (date != null) {
                        this.lastModified = date.getTime();
                        this.lastModifiedDate = date;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date date) {
        this.lastModified = date.getTime();
        this.lastModifiedDate = date;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, date);
        }
    }

    public String getLastModifiedHttp() {
        if (this.lastModifiedHttp != null) {
            return this.lastModifiedHttp;
        }
        Date date = this.getLastModifiedDate();
        if (date == null) {
            date = this.getCreationDate();
        }
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            this.lastModifiedHttp = format.format(date);
        }
        return this.lastModifiedHttp;
    }

    public void setLastModifiedHttp(String string) {
        this.lastModifiedHttp = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getName() {
        Attribute attribute;
        if (this.name != null) {
            return this.name;
        }
        if (this.attributes != null && (attribute = this.attributes.get(NAME)) != null) {
            try {
                this.name = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        if (this.attributes != null) {
            this.attributes.put(NAME, string);
        }
    }

    public String getResourceType() {
        Attribute attribute;
        String string = null;
        if (this.attributes != null && (attribute = this.attributes.get(TYPE)) != null) {
            try {
                string = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = this.collection ? COLLECTION_TYPE : "";
        }
        return string;
    }

    public void setResourceType(String string) {
        this.collection = string.equals(COLLECTION_TYPE);
        if (this.attributes != null) {
            this.attributes.put(TYPE, string);
        }
    }

    public String getETag() {
        return this.getETag(false);
    }

    public String getETag(boolean bl) {
        Attribute attribute;
        String string = null;
        if (this.attributes != null && (attribute = this.attributes.get(ETAG)) != null) {
            try {
                string = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (bl) {
            string = this.strongETag;
        } else {
            if (this.weakETag == null) {
                this.weakETag = "W/\"" + this.getContentLength() + "-" + this.getLastModified() + "\"";
            }
            string = this.weakETag;
        }
        return string;
    }

    public void setETag(String string) {
        this.strongETag = string;
        if (this.attributes != null) {
            this.attributes.put(ETAG, string);
        }
    }

    public Attribute get(String string) {
        if (this.attributes == null) {
            if (string.equals(CREATION_DATE)) {
                return new BasicAttribute(CREATION_DATE, this.getCreationDate());
            }
            if (string.equals(ALTERNATE_CREATION_DATE)) {
                return new BasicAttribute(ALTERNATE_CREATION_DATE, this.getCreationDate());
            }
            if (string.equals(LAST_MODIFIED)) {
                return new BasicAttribute(LAST_MODIFIED, this.getLastModifiedDate());
            }
            if (string.equals(ALTERNATE_LAST_MODIFIED)) {
                return new BasicAttribute(ALTERNATE_LAST_MODIFIED, this.getLastModifiedDate());
            }
            if (string.equals(NAME)) {
                return new BasicAttribute(NAME, this.getName());
            }
            if (string.equals(TYPE)) {
                return new BasicAttribute(TYPE, this.getResourceType());
            }
            if (string.equals(ALTERNATE_TYPE)) {
                return new BasicAttribute(ALTERNATE_TYPE, this.getResourceType());
            }
            if (string.equals(CONTENT_LENGTH)) {
                return new BasicAttribute(CONTENT_LENGTH, new Long(this.getContentLength()));
            }
            if (string.equals(ALTERNATE_CONTENT_LENGTH)) {
                return new BasicAttribute(ALTERNATE_CONTENT_LENGTH, new Long(this.getContentLength()));
            }
        } else {
            return this.attributes.get(string);
        }
        return null;
    }

    public Attribute put(Attribute attribute) {
        if (this.attributes == null) {
            try {
                return this.put(attribute.getID(), attribute.get());
            }
            catch (NamingException namingException) {
                return null;
            }
        }
        return this.attributes.put(attribute);
    }

    public Attribute put(String string, Object object) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.put(string, object);
    }

    public Attribute remove(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(string);
    }

    public NamingEnumeration getAll() {
        if (this.attributes == null) {
            Vector<BasicAttribute> vector = new Vector<BasicAttribute>();
            vector.addElement(new BasicAttribute(CREATION_DATE, this.getCreationDate()));
            vector.addElement(new BasicAttribute(LAST_MODIFIED, this.getLastModifiedDate()));
            vector.addElement(new BasicAttribute(NAME, this.getName()));
            vector.addElement(new BasicAttribute(TYPE, this.getResourceType()));
            vector.addElement(new BasicAttribute(CONTENT_LENGTH, new Long(this.getContentLength())));
            return new RecyclableNamingEnumeration(vector);
        }
        return this.attributes.getAll();
    }

    public NamingEnumeration getIDs() {
        if (this.attributes == null) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(CREATION_DATE);
            vector.addElement(LAST_MODIFIED);
            vector.addElement(NAME);
            vector.addElement(TYPE);
            vector.addElement(CONTENT_LENGTH);
            return new RecyclableNamingEnumeration(vector);
        }
        return this.attributes.getIDs();
    }

    public int size() {
        if (this.attributes == null) {
            return 5;
        }
        return this.attributes.size();
    }

    public Object clone() {
        return this;
    }

    public boolean isCaseIgnored() {
        return false;
    }

    static {
        format.setTimeZone(gmtZone);
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
    }
}

