/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sun.security.util.DerValue;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$keys$content$x509$XMLX509SKI == null ? (class$org$apache$xml$security$keys$content$x509$XMLX509SKI = XMLX509SKI.class$("org.apache.xml.security.keys.content.x509.XMLX509SKI")) : class$org$apache$xml$security$keys$content$x509$XMLX509SKI).getName());
    public static final String SKI_OID = "2.5.29.14";
    static /* synthetic */ Class class$org$apache$xml$security$keys$content$x509$XMLX509SKI;
    static /* synthetic */ Class class$java$io$InputStream;

    public XMLX509SKI(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509SKI(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509Certificate));
    }

    public XMLX509SKI(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate x509Certificate) throws XMLSecurityException {
        try {
            Object object;
            byte[] byArray = x509Certificate.getExtensionValue(SKI_OID);
            if (x509Certificate.getVersion() < 3) {
                Object[] objectArray = new Object[]{new Integer(x509Certificate.getVersion())};
                throw new XMLSecurityException("certificate.noSki.lowVersion", objectArray);
            }
            byte[] byArray2 = null;
            try {
                if (XMLUtils.classForName("sun.security.util.DerValue") != null) {
                    object = new DerValue(byArray);
                    if (object == null) {
                        throw new XMLSecurityException("certificate.noSki.null");
                    }
                    if (((DerValue)object).tag != 4) {
                        throw new XMLSecurityException("certificate.noSki.notOctetString");
                    }
                    byArray2 = ((DerValue)object).getOctetString();
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (byArray2 == null) {
                try {
                    object = XMLUtils.classForName("org.bouncycastle.asn1.DERInputStream");
                    if (object != null) {
                        Constructor constructor = ((Class)object).getConstructor(class$java$io$InputStream == null ? (class$java$io$InputStream = XMLX509SKI.class$("java.io.InputStream")) : class$java$io$InputStream);
                        InputStream inputStream = (InputStream)constructor.newInstance(new ByteArrayInputStream(byArray));
                        Method method = ((Class)object).getMethod("readObject", new Class[0]);
                        Object object2 = method.invoke((Object)inputStream, new Object[0]);
                        if (object2 == null) {
                            throw new XMLSecurityException("certificate.noSki.null");
                        }
                        Class clazz = XMLUtils.classForName("org.bouncycastle.asn1.ASN1OctetString");
                        if (!clazz.isInstance(object2)) {
                            throw new XMLSecurityException("certificate.noSki.notOctetString");
                        }
                        Method method2 = clazz.getMethod("getOctets", new Class[0]);
                        byArray2 = (byte[])method2.invoke(object2, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            object = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, object, 0, ((Object)object).length);
            if (log.isDebugEnabled()) {
                log.debug("Base64 of SKI is " + Base64.encode((byte[])object));
            }
            return object;
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    public boolean equals(Object object) {
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509SKI xMLX509SKI = (XMLX509SKI)object;
        try {
            return JavaUtils.binaryCompare(xMLX509SKI.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509SKI";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

