/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.AttrCompare;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315OmitComments;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class XMLSignatureInput {
    InputStream _inputOctetStreamProxy = null;
    Set _inputNodeSet = null;
    Node _subNode = null;
    Node excludeNode = null;
    boolean excludeComments = false;
    byte[] bytes = null;
    private String _MIMEType = null;
    private String _SourceURI = null;
    OutputStream outputStream = null;

    public XMLSignatureInput(byte[] byArray) {
        this.bytes = byArray;
    }

    public XMLSignatureInput(InputStream inputStream) {
        this._inputOctetStreamProxy = inputStream;
    }

    public XMLSignatureInput(String string) {
        this(string.getBytes());
    }

    public XMLSignatureInput(String string, String string2) throws UnsupportedEncodingException {
        this(string.getBytes(string2));
    }

    public XMLSignatureInput(Node node) {
        this._subNode = node;
    }

    public XMLSignatureInput(Set set) {
        this._inputNodeSet = set;
    }

    public XMLSignatureInput(NodeList nodeList) {
        this(XMLUtils.convertNodelistToSet(nodeList));
    }

    public Set getNodeSet() throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        return this.getNodeSet(false);
    }

    public Set getNodeSet(boolean bl) throws ParserConfigurationException, IOException, SAXException, CanonicalizationException {
        if (this._inputNodeSet != null) {
            return this._inputNodeSet;
        }
        if (this.isElement()) {
            if (bl) {
                XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this._subNode));
            }
            this._inputNodeSet = new HashSet();
            XMLUtils.getSet(this._subNode, this._inputNodeSet, this.excludeNode, this.excludeComments);
            return this._inputNodeSet;
        }
        if (this.isOctetStream()) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
                Document document = documentBuilder.parse(this.getOctetStream());
                XMLUtils.circumventBug2650(document);
                HashSet hashSet = new HashSet();
                XMLUtils.getSet(document.getDocumentElement(), hashSet, null, false);
                return hashSet;
            }
            catch (SAXException sAXException) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write("<container>".getBytes());
                byteArrayOutputStream.write(this.getBytes());
                byteArrayOutputStream.write("</container>".getBytes());
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
                try {
                    NodeList nodeList = CachedXPathAPIHolder.getCachedXPathAPI().selectNodeList(document, "(//. | //@* | //namespace::*)[not(self::node()=/) and not(self::node=/container)]");
                    return XMLUtils.convertNodelistToSet(nodeList);
                }
                catch (TransformerException transformerException) {
                    throw new CanonicalizationException("generic.EmptyMessage", transformerException);
                }
            }
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException, CanonicalizationException {
        return this.getResetableInputStream();
    }

    public InputStream getOctetStreamReal() {
        return this._inputOctetStreamProxy;
    }

    public byte[] getBytes() throws IOException, CanonicalizationException {
        if (this.bytes != null) {
            return this.bytes;
        }
        InputStream inputStream = this.getResetableInputStream();
        if (inputStream != null) {
            if (this.bytes == null) {
                inputStream.reset();
                this.bytes = JavaUtils.getBytesFromStream(inputStream);
            }
            return this.bytes;
        }
        if (this.isElement()) {
            Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
            this.bytes = canonicalizer20010315OmitComments.engineCanonicalizeSubTree(this._subNode, this.excludeNode);
            return this.bytes;
        }
        if (this.isNodeSet()) {
            Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
            if (this._inputNodeSet.size() == 0) {
                return null;
            }
            this.bytes = canonicalizer20010315OmitComments.engineCanonicalizeXPathNodeSet(this._inputNodeSet);
            return this.bytes;
        }
        throw new RuntimeException("getBytes() called but no input data present");
    }

    public boolean isNodeSet() {
        return this._inputOctetStreamProxy == null && this._inputNodeSet != null;
    }

    public boolean isElement() {
        return this._inputOctetStreamProxy == null && this._subNode != null && this._inputNodeSet == null;
    }

    public boolean isOctetStream() {
        return (this._inputOctetStreamProxy != null || this.bytes != null) && this._inputNodeSet == null && this._subNode == null;
    }

    public boolean isByteArray() {
        return this.bytes != null && this._inputNodeSet == null && this._subNode == null;
    }

    public boolean isInitialized() {
        return this.isOctetStream() || this.isNodeSet();
    }

    public String getMIMEType() {
        return this._MIMEType;
    }

    public void setMIMEType(String string) {
        this._MIMEType = string;
    }

    public String getSourceURI() {
        return this._SourceURI;
    }

    public void setSourceURI(String string) {
        this._SourceURI = string;
    }

    public String toString() {
        if (this.isNodeSet()) {
            return "XMLSignatureInput/NodeSet/" + this._inputNodeSet.size() + " nodes/" + this.getSourceURI();
        }
        if (this.isElement()) {
            return "XMLSignatureInput/Element/" + this._subNode + " exclude " + this.excludeNode + " comments:" + this.excludeComments + "/" + this.getSourceURI();
        }
        try {
            return "XMLSignatureInput/OctetStream/" + this.getBytes().length + " octets/" + this.getSourceURI();
        }
        catch (Exception exception) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    public String getHTMLRepresentation(Set set) throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this, set);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    public Node getExcludeNode() {
        return this.excludeNode;
    }

    public void setExcludeNode(Node node) {
        this.excludeNode = node;
    }

    public Node getSubNode() {
        return this._subNode;
    }

    public boolean isExcludeComments() {
        return this.excludeComments;
    }

    public void setExcludeComments(boolean bl) {
        this.excludeComments = bl;
    }

    public void updateOutputStream(OutputStream outputStream) throws CanonicalizationException, IOException {
        int n;
        if (outputStream == this.outputStream) {
            return;
        }
        if (this.bytes != null) {
            outputStream.write(this.bytes);
            return;
        }
        if (this.isElement()) {
            Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
            canonicalizer20010315OmitComments.setWriter(outputStream);
            canonicalizer20010315OmitComments.engineCanonicalizeSubTree(this._subNode, this.excludeNode);
            return;
        }
        if (this.isNodeSet()) {
            Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
            canonicalizer20010315OmitComments.setWriter(outputStream);
            if (this._inputNodeSet.size() == 0) {
                return;
            }
            canonicalizer20010315OmitComments.engineCanonicalizeXPathNodeSet(this._inputNodeSet);
            return;
        }
        InputStream inputStream = this.getResetableInputStream();
        if (this.bytes != null) {
            outputStream.write(this.bytes, 0, this.bytes.length);
            return;
        }
        inputStream.reset();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected InputStream getResetableInputStream() throws IOException {
        if (this._inputOctetStreamProxy instanceof ByteArrayInputStream) {
            if (!this._inputOctetStreamProxy.markSupported()) {
                throw new RuntimeException("Accepted as Markable but not truly been" + this._inputOctetStreamProxy);
            }
            return this._inputOctetStreamProxy;
        }
        if (this.bytes != null) {
            this._inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
            return this._inputOctetStreamProxy;
        }
        if (this._inputOctetStreamProxy == null) {
            return null;
        }
        if (this._inputOctetStreamProxy.markSupported()) {
            System.err.println("Mark Suported but not used as reset");
        }
        this.bytes = JavaUtils.getBytesFromStream(this._inputOctetStreamProxy);
        this._inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
        return this._inputOctetStreamProxy;
    }

    public class XMLSignatureInputDebugger {
        private Set _xpathNodeSet;
        private Set _inclusiveNamespaces;
        private Document _doc = null;
        private Writer _writer = null;
        static final String HTMLPrefix = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n";
        static final String HTMLSuffix = "</pre></body></html>";
        static final String HTMLExcludePrefix = "<span class=\"EXCLUDED\">";
        static final String HTMLExcludeSuffix = "</span>";
        static final String HTMLIncludePrefix = "<span class=\"INCLUDED\">";
        static final String HTMLIncludeSuffix = "</span>";
        static final String HTMLIncludedInclusiveNamespacePrefix = "<span class=\"INCLUDEDINCLUSIVENAMESPACE\">";
        static final String HTMLIncludedInclusiveNamespaceSuffix = "</span>";
        static final String HTMLExcludedInclusiveNamespacePrefix = "<span class=\"EXCLUDEDINCLUSIVENAMESPACE\">";
        static final String HTMLExcludedInclusiveNamespaceSuffix = "</span>";
        private static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
        private static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
        private static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;

        private XMLSignatureInputDebugger() {
        }

        public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput2) {
            this._xpathNodeSet = !xMLSignatureInput2.isNodeSet() ? null : xMLSignatureInput2._inputNodeSet;
        }

        public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput2, Set set) {
            this(xMLSignatureInput2);
            this._inclusiveNamespaces = set;
        }

        public String getHTMLRepresentation() throws XMLSignatureException {
            if (this._xpathNodeSet == null || this._xpathNodeSet.size() == 0) {
                return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n<blink>no node set, sorry</blink></pre></body></html>";
            }
            Object object = (Node)this._xpathNodeSet.iterator().next();
            this._doc = XMLUtils.getOwnerDocument((Node)object);
            try {
                this._writer = new StringWriter();
                this.canonicalizeXPathNodeSet(this._doc);
                this._writer.close();
                object = this._writer.toString();
                Object var3_3 = null;
                this._xpathNodeSet = null;
                this._doc = null;
                this._writer = null;
                return object;
            }
            catch (IOException iOException) {
                try {
                    throw new XMLSignatureException("empty", iOException);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this._xpathNodeSet = null;
                    this._doc = null;
                    this._writer = null;
                    throw throwable;
                }
            }
        }

        private void canonicalizeXPathNodeSet(Node node) throws XMLSignatureException, IOException {
            short s = node.getNodeType();
            switch (s) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 11: 
                case 12: {
                    throw new XMLSignatureException("empty");
                }
                case 9: {
                    this._writer.write(HTMLPrefix);
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        this.canonicalizeXPathNodeSet(node2);
                    }
                    this._writer.write(HTMLSuffix);
                    break;
                }
                case 8: {
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    int n = this.getPositionRelativeToDocumentElement(node);
                    if (n == 1) {
                        this._writer.write("\n");
                    }
                    this.outputCommentToWriter((Comment)node);
                    if (n == -1) {
                        this._writer.write("\n");
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 7: {
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    int n = this.getPositionRelativeToDocumentElement(node);
                    if (n == 1) {
                        this._writer.write("\n");
                    }
                    this.outputPItoWriter((ProcessingInstruction)node);
                    if (n == -1) {
                        this._writer.write("\n");
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 3: 
                case 4: {
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this.outputTextToWriter(node.getNodeValue());
                    for (Node node3 = node.getNextSibling(); node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4); node3 = node3.getNextSibling()) {
                        this.outputTextToWriter(node3.getNodeValue());
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 1: {
                    Element element = (Element)node;
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&lt;");
                    this._writer.write(element.getTagName());
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                    } else {
                        this._writer.write("</span>");
                    }
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = namedNodeMap.item(i);
                    }
                    Arrays.sort(objectArray, new AttrCompare());
                    Object[] objectArray2 = objectArray;
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)objectArray2[i];
                        boolean bl = this._xpathNodeSet.contains(attr);
                        boolean bl2 = this._inclusiveNamespaces.contains(attr.getName());
                        if (bl) {
                            if (bl2) {
                                this._writer.write(HTMLIncludedInclusiveNamespacePrefix);
                            } else {
                                this._writer.write(HTMLIncludePrefix);
                            }
                        } else if (bl2) {
                            this._writer.write(HTMLExcludedInclusiveNamespacePrefix);
                        } else {
                            this._writer.write(HTMLExcludePrefix);
                        }
                        this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                        if (bl) {
                            if (bl2) {
                                this._writer.write("</span>");
                                continue;
                            }
                            this._writer.write("</span>");
                            continue;
                        }
                        if (bl2) {
                            this._writer.write("</span>");
                            continue;
                        }
                        this._writer.write("</span>");
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&gt;");
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                    } else {
                        this._writer.write("</span>");
                    }
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                        this.canonicalizeXPathNodeSet(node4);
                    }
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&lt;/");
                    this._writer.write(element.getTagName());
                    this._writer.write("&gt;");
                    if (this._xpathNodeSet.contains(node)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                }
            }
        }

        private int getPositionRelativeToDocumentElement(Node node) {
            if (node == null) {
                return 0;
            }
            Document document = node.getOwnerDocument();
            if (node.getParentNode() != document) {
                return 0;
            }
            Element element = document.getDocumentElement();
            if (element == null) {
                return 0;
            }
            if (element == node) {
                return 0;
            }
            for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
                if (node2 != element) continue;
                return -1;
            }
            return 1;
        }

        private void outputAttrToWriter(String string, String string2) throws IOException {
            this._writer.write(" ");
            this._writer.write(string);
            this._writer.write("=\"");
            int n = string2.length();
            block8: for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                switch (c) {
                    case '&': {
                        this._writer.write("&amp;amp;");
                        continue block8;
                    }
                    case '<': {
                        this._writer.write("&amp;lt;");
                        continue block8;
                    }
                    case '\"': {
                        this._writer.write("&amp;quot;");
                        continue block8;
                    }
                    case '\t': {
                        this._writer.write("&amp;#x9;");
                        continue block8;
                    }
                    case '\n': {
                        this._writer.write("&amp;#xA;");
                        continue block8;
                    }
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        continue block8;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
            }
            this._writer.write("\"");
        }

        private void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
            int n;
            if (processingInstruction == null) {
                return;
            }
            this._writer.write("&lt;?");
            String string = processingInstruction.getTarget();
            int n2 = string.length();
            block8: for (int i = 0; i < n2; ++i) {
                n = string.charAt(i);
                switch (n) {
                    case 13: {
                        this._writer.write("&amp;#xD;");
                        continue block8;
                    }
                    case 32: {
                        this._writer.write("&middot;");
                        continue block8;
                    }
                    case 10: {
                        this._writer.write("&para;\n");
                        continue block8;
                    }
                    default: {
                        this._writer.write(n);
                    }
                }
            }
            String string2 = processingInstruction.getData();
            n2 = string2.length();
            if (string2 != null && n2 > 0) {
                this._writer.write(" ");
                block9: for (n = 0; n < n2; ++n) {
                    char c = string2.charAt(n);
                    switch (c) {
                        case '\r': {
                            this._writer.write("&amp;#xD;");
                            continue block9;
                        }
                        default: {
                            this._writer.write(c);
                        }
                    }
                }
            }
            this._writer.write("?&gt;");
        }

        private void outputCommentToWriter(Comment comment) throws IOException {
            if (comment == null) {
                return;
            }
            this._writer.write("&lt;!--");
            String string = comment.getData();
            int n = string.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        continue block5;
                    }
                    case ' ': {
                        this._writer.write("&middot;");
                        continue block5;
                    }
                    case '\n': {
                        this._writer.write("&para;\n");
                        continue block5;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
            }
            this._writer.write("--&gt;");
        }

        private void outputTextToWriter(String string) throws IOException {
            if (string == null) {
                return;
            }
            int n = string.length();
            block8: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        this._writer.write("&amp;amp;");
                        continue block8;
                    }
                    case '<': {
                        this._writer.write("&amp;lt;");
                        continue block8;
                    }
                    case '>': {
                        this._writer.write("&amp;gt;");
                        continue block8;
                    }
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        continue block8;
                    }
                    case ' ': {
                        this._writer.write("&middot;");
                        continue block8;
                    }
                    case '\n': {
                        this._writer.write("&para;\n");
                        continue block8;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
            }
        }
    }
}

