/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListMetaData;
import org.globus.wsrf.TopicListener;
import org.globus.wsrf.WSNConstants;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleTopicListMetaData;
import org.globus.wsrf.impl.TopicExpressionEngineImpl;
import org.globus.wsrf.topicexpression.InvalidTopicExpressionException;
import org.globus.wsrf.topicexpression.TopicExpressionEngine;
import org.globus.wsrf.topicexpression.TopicExpressionEvaluator;
import org.globus.wsrf.topicexpression.TopicExpressionException;
import org.globus.wsrf.topicexpression.TopicExpressionResolutionException;
import org.globus.wsrf.topicexpression.UnsupportedTopicExpressionDialectException;
import org.oasis.wsn.TopicExpressionType;

public class SimpleTopicList
implements TopicList,
TopicListener {
    protected Map rootTopics = new HashMap();
    protected Collection listeners = new Vector();
    private ResourceProperty supportedTopics = new SimpleResourceProperty(WSNConstants.TOPIC);
    private ResourceProperty fixedTopicSet = new SimpleResourceProperty(WSNConstants.FIXED_TOPIC_SET);
    private static TopicExpressionEngine topicExpressionEngine = TopicExpressionEngineImpl.getInstance();
    private TopicListMetaData metaData;
    static Log logger = LogFactory.getLog(SimpleTopicList.class.getName());

    public SimpleTopicList(ResourceProperties resource) {
        this(resource, new SimpleTopicListMetaData(false));
    }

    public SimpleTopicList(ResourceProperties resource, TopicListMetaData metaData) {
        this.metaData = metaData;
        ResourcePropertySet propertySet = resource.getResourcePropertySet();
        this.fixedTopicSet.add(new Boolean(metaData.isTopicSetFixed()));
        propertySet.add(this.fixedTopicSet);
        propertySet.add(this.supportedTopics);
        try {
            propertySet.add(new ReflectionResourceProperty(WSNConstants.TOPIC_EXPRESSION_DIALECTS, "SupportedDialects", (Object)topicExpressionEngine));
        }
        catch (Exception e) {
            logger.debug("Failed to set up SupportedDialects RP", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void addTopic(Topic topic) {
        this.rootTopics.put(topic.getName(), topic);
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(topic.getName());
        topic.setTopicPath(topicPath);
        topic.addTopicListener(this);
        this.topicAdded(topic);
    }

    public synchronized void addTopicListener(TopicListener listener) {
        this.listeners.add(listener);
    }

    public Collection getTopics(TopicExpressionType topicExpression) throws UnsupportedTopicExpressionDialectException, TopicExpressionResolutionException, InvalidTopicExpressionException, TopicExpressionException {
        return topicExpressionEngine.resolveTopicExpression(topicExpression, this);
    }

    public void removeTopic(Topic topic) {
        this.rootTopics.remove(topic.getName());
        topic.removeTopicListener(this);
        this.topicRemoved(topic);
    }

    public synchronized void removeTopicListener(TopicListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized Iterator topicListenerIterator() {
        return this.listeners.iterator();
    }

    public Topic getTopic(List topicPath) {
        Iterator pathIterator = topicPath.iterator();
        Topic topic = null;
        while (pathIterator.hasNext()) {
            QName topicName = (QName)pathIterator.next();
            if ((topic = topic == null ? (Topic)this.rootTopics.get(topicName) : topic.getTopic(topicName)) != null) continue;
            return null;
        }
        return topic;
    }

    public TopicListMetaData getTopicListMetaData() {
        return this.metaData;
    }

    public Iterator topicIterator() {
        return this.rootTopics.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void topicAdded(Topic topic) {
        TopicExpressionEvaluator evaluator = topicExpressionEngine.getEvaluator("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
        TopicExpressionType topicExpression = null;
        try {
            topicExpression = evaluator.toTopicExpression(topic.getTopicPath());
        }
        catch (Exception e) {
            logger.debug("Failed to create topic expression from topic path", e);
            throw new RuntimeException(e.getMessage());
        }
        this.supportedTopics.add(topicExpression);
        SimpleTopicList simpleTopicList = this;
        synchronized (simpleTopicList) {
            Iterator listenerIterator = this.listeners.iterator();
            while (listenerIterator.hasNext()) {
                TopicListener listener = (TopicListener)listenerIterator.next();
                listener.topicAdded(topic);
            }
        }
    }

    public synchronized void topicChanged(Topic topic) {
        Iterator listenerIterator = this.listeners.iterator();
        if (logger.isDebugEnabled()) {
            logger.debug("being notified that a topic has changed");
        }
        while (listenerIterator.hasNext()) {
            TopicListener listener = (TopicListener)listenerIterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug("notifying listener " + listener);
            }
            listener.topicChanged(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void topicRemoved(Topic topic) {
        TopicExpressionEvaluator evaluator = topicExpressionEngine.getEvaluator("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
        TopicExpressionType topicExpression = null;
        try {
            topicExpression = evaluator.toTopicExpression(topic.getTopicPath());
        }
        catch (Exception e) {
            logger.debug("Failed to create topic expression from topic path", e);
            throw new RuntimeException(e.getMessage());
        }
        this.supportedTopics.remove(topicExpression);
        SimpleTopicList simpleTopicList = this;
        synchronized (simpleTopicList) {
            Iterator listenerIterator = this.listeners.iterator();
            while (listenerIterator.hasNext()) {
                TopicListener listener = (TopicListener)listenerIterator.next();
                listener.topicRemoved(topic);
            }
        }
    }
}

