/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.producer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBETestProbe;
import org.gcube.common.core.monitoring.LocalMonitor;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.messaging.endpoints.BrokerEndpoints;
import org.gcube.common.messaging.endpoints.ScheduledRetriever;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.messaging.common.producer.BrokerNotConfiguredInScopeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBELocalProducer
extends LocalMonitor {
    private static long refreshTime = 1800L;
    private static long waitingTime = 60L;
    private static Logger logger = LoggerFactory.getLogger(GCUBELocalProducer.class);
    private static HashMap<GCUBEScope, ScheduledRetriever> brokerMap = new HashMap();
    private static HashMap<GCUBEScope, ArrayList<ActiveMQConnectionFactory>> connectionFactoryMap = null;
    private static HashMap<GCUBEScope, ArrayList<QueueConnection>> queueConnectionMap = null;
    static Properties resources = new Properties();

    public GCUBELocalProducer() {
        try {
            GCUBELocalProducer.addScope(GCUBEScope.getScope((String)("/" + GHNContext.getContext().getGHN().getInfrastructure())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadProbes(Map<String, Class<? extends GCUBETestProbe>> map) {
        try {
            Properties query = new Properties();
            query.load(GCUBELocalProducer.class.getResourceAsStream("/probes.properties"));
            for (Object prop : query.keySet()) {
                try {
                    map.put((String)prop, Class.forName((String)query.get(prop)));
                }
                catch (Exception e) {
                    logger.error("Error loading probe class", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error loading probes configuration", (Throwable)e);
        }
    }

    public static ArrayList<QueueConnection> getQueueConnection(GCUBEScope scope) {
        ArrayList<QueueConnection> connection = queueConnectionMap.get(scope);
        if (connection == null) {
            logger.debug("CONNECTION MAP NULL");
        }
        return connection;
    }

    public static synchronized void addScope(GCUBEScope scope) throws BrokerNotConfiguredInScopeException, Exception {
        if (!brokerMap.containsKey(scope)) {
            ScopeProvider.instance.set(scope.toString());
            ScheduledRetriever ret = BrokerEndpoints.getRetriever((long)waitingTime, (long)refreshTime);
            if (ret.getFailoverEndpoint() != null) {
                brokerMap.put(scope, ret);
            } else {
                throw new BrokerNotConfiguredInScopeException();
            }
        }
    }

    public static synchronized Set<GCUBEScope> getMonitoredScope() {
        return brokerMap.keySet();
    }

    public static synchronized void removeScope(GCUBEScope scope) {
        brokerMap.remove(scope);
    }

    public static synchronized void reloadConnection(GCUBEScope scope) {
        GCUBELocalProducer.stopConnections(scope);
        ArrayList<ActiveMQConnectionFactory> factoryList = new ArrayList<ActiveMQConnectionFactory>();
        ArrayList<QueueConnection> queueConnectionList = new ArrayList<QueueConnection>();
        logger.debug("Reload JMS connections");
        ScheduledRetriever ret = brokerMap.get(scope);
        try {
            logger.info("JMS failover endpoint: " + ret.getFailoverEndpoint() + " for scope: " + scope.toString());
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(ret.getFailoverEndpoint());
            factoryList.add(factory);
            QueueConnection queueCon = factory.createQueueConnection();
            queueConnectionList.add(queueCon);
            queueCon.start();
        }
        catch (JMSException e1) {
            logger.error("Error creating Topic Connection", (Throwable)e1);
        }
        catch (Exception e) {
            logger.error("Error creating Topic Connection", (Throwable)e);
        }
        queueConnectionMap.put(scope, queueConnectionList);
        connectionFactoryMap.put(scope, factoryList);
    }

    public void run() {
        connectionFactoryMap = new HashMap();
        queueConnectionMap = new HashMap();
        for (GCUBEScope scope : brokerMap.keySet()) {
            logger.info("Broker Map, scope to monitor: " + scope.toString());
            GCUBELocalProducer.reloadConnection(scope);
        }
        if (this.implementationMap == null) {
            this.implementationMap = Collections.synchronizedMap(new HashMap());
            this.loadProbes(this.implementationMap);
        }
        for (Class classProbe : this.implementationMap.values()) {
            try {
                GCUBETestProbe probe = (GCUBETestProbe)classProbe.newInstance();
                probe.setInterval(this.interval);
                logger.info("Initializing " + classProbe + " Probe");
                probe.execute();
            }
            catch (Exception e) {
                logger.error("Error Initializing probe " + classProbe, (Throwable)e);
            }
        }
    }

    public static boolean checkStartScope(GCUBEScope scope) {
        boolean isStartScope = false;
        for (GCUBEScope scopeStart : GHNContext.getContext().getStartScopes()) {
            if (!scope.equals((Object)scopeStart) && !scope.isInfrastructure()) continue;
            isStartScope = true;
        }
        return isStartScope;
    }

    private static void stopConnections(GCUBEScope scope) {
        if (queueConnectionMap != null && queueConnectionMap.get(scope) != null) {
            for (QueueConnection con : queueConnectionMap.get(scope)) {
                try {
                    con.stop();
                    con.close();
                }
                catch (JMSException e) {
                    logger.error("Error stopping queueConnections", (Throwable)e);
                }
            }
        }
    }
}

