/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.messages.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final SQLType ARRAY = new SQLType("ARRAY", 2003);
    public static final SQLType BIGINT = new SQLType("BIGINT", -5);
    public static final SQLType BINARY = new SQLType("BINARY", -2);
    public static final SQLType BIT = new SQLType("BIT", -7);
    public static final SQLType BLOB = new SQLType("BLOB", 2004);
    public static final SQLType BOOLEAN = new SQLType("BOOLEAN", 16);
    public static final SQLType CHAR = new SQLType("BLOB", 1);
    public static final SQLType CLOB = new SQLType("CLOB", 2005);
    public static final SQLType DATALINK = new SQLType("DATALINK", 70);
    public static final SQLType DATE = new SQLType("DATE", 91);
    public static final SQLType DECIMAL = new SQLType("DECIMAL", 3);
    public static final SQLType DISTINCT = new SQLType("DECIMAL", 2001);
    public static final SQLType DOUBLE = new SQLType("DOUBLE", 8);
    public static final SQLType FLOAT = new SQLType("FLOAT", 6);
    public static final SQLType INTEGER = new SQLType("INTEGER", 4);
    public static final SQLType JAVA_OBJECT = new SQLType("INTEGER", 2000);
    public static final SQLType LONGVARBINARY = new SQLType("LONGVARBINARY", -4);
    public static final SQLType LONGVARCHAR = new SQLType("LONGVARBINARY", -1);
    public static final SQLType NULL = new SQLType("NULL", 0);
    public static final SQLType NUMERIC = new SQLType("NUMERIC", 2);
    public static final SQLType OTHER = new SQLType("OTHER", 1111);
    public static final SQLType REAL = new SQLType("REAL", 7);
    public static final SQLType REF = new SQLType("REF", 2006);
    public static final SQLType SMALLINT = new SQLType("SMALLINT", 5);
    public static final SQLType STRUCT = new SQLType("STRUCT", 2002);
    public static final SQLType TIME = new SQLType("TIME", 92);
    public static final SQLType TIMESTAMP = new SQLType("TIMESTAMP", 93);
    public static final SQLType TINYINT = new SQLType("TINYINT", -6);
    public static final SQLType VARBINARY = new SQLType("VARBINARY", -3);
    public static final SQLType VARCHAR = new SQLType("VARCHAR", 12);
    private final String myName;
    private int jdbcSQLType;

    private SQLType(String name, int jdbcSQLTypeValue) {
        this.myName = name;
        this.jdbcSQLType = jdbcSQLTypeValue;
    }

    public static SQLType getSQLType(Object object) {
        if (object instanceof String) {
            return VARCHAR;
        }
        if (object instanceof BigDecimal) {
            return NUMERIC;
        }
        if (object instanceof Boolean) {
            return BIT;
        }
        if (object instanceof Integer) {
            return INTEGER;
        }
        if (object instanceof Long) {
            return BIGINT;
        }
        if (object instanceof Float) {
            return REAL;
        }
        if (object instanceof Double) {
            return DOUBLE;
        }
        if (object instanceof byte[]) {
            return LONGVARBINARY;
        }
        if (object instanceof Date) {
            return DATE;
        }
        if (object instanceof Time) {
            return TIME;
        }
        if (object instanceof Timestamp) {
            return TIMESTAMP;
        }
        if (object instanceof Clob) {
            return CLOB;
        }
        if (object instanceof Blob) {
            return BLOB;
        }
        if (object instanceof Array) {
            return ARRAY;
        }
        if (object instanceof Struct) {
            return STRUCT;
        }
        if (object instanceof Ref) {
            return REF;
        }
        throw new IllegalArgumentException("Unsupported JAVA Type: " + object.getClass().getCanonicalName());
    }

    public static SQLType getSQLType(int jdbcSQLType) {
        switch (jdbcSQLType) {
            case 2003: {
                return ARRAY;
            }
            case -5: {
                return BIGINT;
            }
            case -2: {
                return BINARY;
            }
            case -7: {
                return BIT;
            }
            case 2004: {
                return BLOB;
            }
            case 16: {
                return BOOLEAN;
            }
            case 1: {
                return CHAR;
            }
            case 2005: {
                return CLOB;
            }
            case 70: {
                return DATALINK;
            }
            case 91: {
                return DATE;
            }
            case 3: {
                return DECIMAL;
            }
            case 8: {
                return DOUBLE;
            }
            case 2001: {
                return DISTINCT;
            }
            case 6: {
                return FLOAT;
            }
            case 4: {
                return INTEGER;
            }
            case 2000: {
                return JAVA_OBJECT;
            }
            case -4: {
                return LONGVARBINARY;
            }
            case -1: {
                return LONGVARCHAR;
            }
            case 0: {
                return NULL;
            }
            case 2: {
                return NUMERIC;
            }
            case 1111: {
                return OTHER;
            }
            case 7: {
                return REAL;
            }
            case 2006: {
                return REF;
            }
            case 5: {
                return SMALLINT;
            }
            case 2002: {
                return STRUCT;
            }
            case 92: {
                return TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case -6: {
                return TINYINT;
            }
            case -3: {
                return VARBINARY;
            }
            case 12: {
                return VARCHAR;
            }
        }
        throw new IllegalArgumentException("Unricognized JDBC SQL Type: " + jdbcSQLType + " Please refer to java.sql.Types of J2SE API");
    }

    public String toString() {
        return "SQL type: " + this.myName + " JDBC SQL type: " + this.jdbcSQLType;
    }

    public String getName() {
        return this.myName;
    }

    public int getJDBCSQLType() {
        return this.jdbcSQLType;
    }
}

