/*
 * Decompiled with CFR 0.152.
 */
package org.globus.usage.packets;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.usage.packets.CustomByteBuffer;
import org.globus.usage.packets.PacketFieldParser;
import org.globus.usage.packets.UsageMonitorPacket;

public class CStylePacket
extends UsageMonitorPacket {
    private static Log log = LogFactory.getLog((String)(class$org$globus$usage$packets$IPTimeMonitorPacket == null ? (class$org$globus$usage$packets$IPTimeMonitorPacket = CStylePacket.class$("org.globus.usage.packets.IPTimeMonitorPacket")) : class$org$globus$usage$packets$IPTimeMonitorPacket).getName());
    protected long timeSent;
    protected InetAddress senderAddress;
    static /* synthetic */ Class class$org$globus$usage$packets$IPTimeMonitorPacket;

    public void setDateTime(Date d) {
        this.timeSent = d.getTime();
    }

    public Date getDateTime() {
        return new Date(this.timeSent);
    }

    public long getTimestamp() {
        return this.timeSent;
    }

    public void setTimestamp(long time) {
        this.timeSent = time;
    }

    public void setHostIP(InetAddress addr) {
        this.senderAddress = addr;
    }

    public InetAddress getHostIP() {
        return this.senderAddress;
    }

    public void packCustomFields(CustomByteBuffer buf) {
        super.packCustomFields(buf);
        buf.putInt((int)(this.timeSent / 1000L));
        byte[] addressByteArray = this.senderAddress.getAddress();
        buf.put(addressByteArray);
    }

    public void unpackCustomFields(CustomByteBuffer buf) {
        super.unpackCustomFields(buf);
        byte[] ipBytes = new byte[16];
        buf.getBytes(ipBytes);
        try {
            this.senderAddress = InetAddress.getByAddress(ipBytes);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.timeSent = this.readCStyleTimestamp(buf).getTime();
    }

    protected PacketFieldParser parseTextSection(CustomByteBuffer buf) {
        String contents = new String(buf.getRemainingBytes());
        PacketFieldParser parser = new PacketFieldParser(contents);
        return parser;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(", sent at: " + this.getDateTime());
        buf.append(", from: " + this.getHostIP());
        return buf.toString();
    }

    protected Date readCStyleTimestamp(CustomByteBuffer buf) {
        Calendar epoch = Calendar.getInstance();
        int secondsSinceEpoch = buf.getIntBigEndian();
        epoch.set(1970, 0, 0, 0, 0, 0);
        epoch.set(14, 0);
        epoch.add(13, secondsSinceEpoch);
        if (secondsSinceEpoch < 0) {
            epoch.add(13, Integer.MAX_VALUE);
        }
        return epoch.getTime();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

