/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.condition;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.taskdefs.condition.IsTrue;

public class DateTimeBefore
extends IsTrue
implements Condition {
    private String date1;
    private String date2;
    private String format = null;
    private boolean lenient = true;

    public void setDatetime1(String date) {
        if (date == null) {
            return;
        }
        if (this.date1 == null) {
            this.date1 = date;
        }
    }

    public void setDatetime2(String date) {
        if (date == null) {
            return;
        }
        if (this.date2 == null) {
            this.date2 = date;
        }
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLenient(boolean b) {
        this.lenient = b;
    }

    public boolean eval() throws BuildException {
        try {
            if (this.format == null) {
                throw new BuildException("format is required");
            }
            SimpleDateFormat df = new SimpleDateFormat(this.format);
            df.setLenient(this.lenient);
            if (this.date1 == null || this.date2 == null) {
                throw new BuildException("Both datetime1 and datetime2 must be set.");
            }
            Date d1 = df.parse(this.date1);
            Date d2 = df.parse(this.date2);
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(d1);
            cal2.setTime(d2);
            return cal1.before(cal2);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }
}

