/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import ise.library.FileUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class Os {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private String family;
    private String name;
    private String version;
    private String arch;
    private static Hashtable environment;

    public Os() {
    }

    public Os(String family) {
        this.setFamily(family);
    }

    public void setFamily(String f) {
        this.family = f.toLowerCase(Locale.US);
    }

    public void setName(String name) {
        this.name = name.toLowerCase(Locale.US);
    }

    public void setArch(String arch) {
        this.arch = arch.toLowerCase(Locale.US);
    }

    public void setVersion(String version) {
        this.version = version.toLowerCase(Locale.US);
    }

    public boolean eval() {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return Os.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return Os.isOs(null, null, null, version);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                if (family.equals("windows")) {
                    isFamily = OS_NAME.indexOf("windows") > -1;
                } else if (family.equals("os/2")) {
                    isFamily = OS_NAME.indexOf("os/2") > -1;
                } else if (family.equals("netware")) {
                    isFamily = OS_NAME.indexOf("netware") > -1;
                } else if (family.equals("dos")) {
                    isFamily = PATH_SEP.equals(";") && !Os.isFamily("netware");
                } else if (family.equals("mac")) {
                    isFamily = OS_NAME.indexOf("mac") > -1;
                } else if (family.equals("tandem")) {
                    isFamily = OS_NAME.indexOf("nonstop_kernel") > -1;
                } else if (family.equals("unix")) {
                    isFamily = PATH_SEP.equals(":") && !Os.isFamily("openvms") && (!Os.isFamily("mac") || OS_NAME.endsWith("x"));
                } else if (family.equals("win9x")) {
                    isFamily = Os.isFamily("windows") && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0);
                } else if (family.equals("z/os")) {
                    isFamily = OS_NAME.indexOf("z/os") > -1 || OS_NAME.indexOf("os/390") > -1;
                } else if (family.equals("os/400")) {
                    isFamily = OS_NAME.indexOf("os/400") > -1;
                } else if (family.equals("openvms")) {
                    isFamily = OS_NAME.indexOf("openvms") > -1;
                } else {
                    return false;
                }
            }
            if (name != null) {
                isName = name.equals(OS_NAME);
            }
            if (arch != null) {
                isArch = arch.equals(OS_ARCH);
            }
            if (version != null) {
                isVersion = version.equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    public static String getEnvironmentValue(String name) {
        if (environment != null) {
            return (String)environment.get(name);
        }
        environment = new Hashtable();
        try {
            String line;
            String[] env_cmd = Os.getProcEnvCommand();
            Process process = Runtime.getRuntime().exec(env_cmd);
            BufferedInputStream is = new BufferedInputStream(process.getInputStream());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtilities.copy((InputStream)is, baos);
            BufferedReader in = new BufferedReader(new StringReader(baos.toString()));
            Vector<String> procEnvironment = new Vector<String>();
            String var = null;
            String lineSep = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                if (line.indexOf(61) == -1) {
                    if (var == null) {
                        var = lineSep + line;
                        continue;
                    }
                    var = var + lineSep + line;
                    continue;
                }
                if (var != null) {
                    procEnvironment.addElement(var);
                }
                var = line;
            }
            if (var != null) {
                procEnvironment.addElement(var);
            }
            if (procEnvironment.size() > 0) {
                Iterator it = procEnvironment.iterator();
                while (it.hasNext()) {
                    var = (String)it.next();
                    int index = var.indexOf("=");
                    String key = var.substring(0, index);
                    String value = var.substring(index + 1);
                    environment.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Os.getEnvironmentValue(name);
    }

    private static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("windows")) {
            if (!Os.isFamily("win9x")) {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                return cmd;
            }
            String[] cmd = new String[]{"command.com", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("z/os") || Os.isFamily("unix")) {
            String[] cmd = new String[]{new File("/bin/env").canRead() ? "/bin/env" : (new File("/usr/bin/env").canRead() ? "/usr/bin/env" : "env")};
            return cmd;
        }
        if (Os.isFamily("netware") || Os.isFamily("os/400")) {
            String[] cmd = new String[]{"env"};
            return cmd;
        }
        if (Os.isFamily("openvms")) {
            String[] cmd = new String[]{"show", "logical"};
            return cmd;
        }
        String[] cmd = null;
        return cmd;
    }
}

