/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.storage;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.storage.StorageResolverException;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.keys.storage.implementations.KeyStoreResolver;
import org.apache.xml.security.keys.storage.implementations.SingleCertificateResolver;

public class StorageResolver {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$keys$storage$StorageResolver == null ? (class$org$apache$xml$security$keys$storage$StorageResolver = StorageResolver.class$("org.apache.xml.security.keys.storage.StorageResolver")) : class$org$apache$xml$security$keys$storage$StorageResolver).getName());
    Vector _storageResolvers = new Vector();
    Iterator _iterator = null;
    static /* synthetic */ Class class$org$apache$xml$security$keys$storage$StorageResolver;

    public StorageResolver() {
    }

    public StorageResolver(StorageResolverSpi storageResolverSpi) {
        this.add(storageResolverSpi);
    }

    public void add(StorageResolverSpi storageResolverSpi) {
        this._storageResolvers.add(storageResolverSpi);
        this._iterator = null;
    }

    public StorageResolver(KeyStore keyStore) {
        this.add(keyStore);
    }

    public void add(KeyStore keyStore) {
        try {
            this.add(new KeyStoreResolver(keyStore));
        }
        catch (StorageResolverException storageResolverException) {
            log.error("Could not add KeyStore because of: ", storageResolverException);
        }
    }

    public StorageResolver(X509Certificate x509Certificate) {
        this.add(x509Certificate);
    }

    public void add(X509Certificate x509Certificate) {
        this.add(new SingleCertificateResolver(x509Certificate));
    }

    public Iterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new StorageResolverIterator(this._storageResolvers);
        }
        return this._iterator;
    }

    public boolean hasNext() {
        if (this._iterator == null) {
            this._iterator = new StorageResolverIterator(this._storageResolvers);
        }
        return this._iterator.hasNext();
    }

    public X509Certificate next() {
        return (X509Certificate)this._iterator.next();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StorageResolverIterator
    implements Iterator {
        Vector _resolvers = null;
        int _currentResolver = 0;

        public StorageResolverIterator(Vector vector) {
            this._resolvers = vector;
            this._currentResolver = 0;
        }

        public boolean hasNext() {
            if (this._resolvers == null) {
                return false;
            }
            while (this._currentResolver < this._resolvers.size()) {
                StorageResolverSpi storageResolverSpi = (StorageResolverSpi)this._resolvers.elementAt(this._currentResolver);
                if (storageResolverSpi == null) continue;
                if (storageResolverSpi.getIterator().hasNext()) {
                    return true;
                }
                ++this._currentResolver;
            }
            return false;
        }

        public Object next() {
            if (this._resolvers == null) {
                return null;
            }
            while (this._currentResolver < this._resolvers.size()) {
                StorageResolverSpi storageResolverSpi = (StorageResolverSpi)this._resolvers.elementAt(this._currentResolver);
                if (storageResolverSpi == null) continue;
                if (storageResolverSpi.getIterator().hasNext()) {
                    return storageResolverSpi.getIterator().next();
                }
                ++this._currentResolver;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

