/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.catalina.valves;

import java.io.IOException;
import java.net.Socket;
import javax.servlet.ServletException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.valves.ValveBase;
import org.globus.tomcat.catalina.net.HTTPSSocket;
import org.ietf.jgss.GSSContext;

public final class HTTPSValve
extends ValveBase {
    protected static final String info = "org.globus.tomcat.catalina.valves.HTTPSTransportValve/1.0";

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        this.expose(request);
        context.invokeNext(request, response);
    }

    protected void expose(Request request) {
        Socket s = request.getSocket();
        if (s == null) {
            return;
        }
        if (!(s instanceof HTTPSSocket)) {
            return;
        }
        HTTPSSocket socket = (HTTPSSocket)((Object)s);
        String globusID = socket.getUserDN();
        if (globusID != null) {
            request.getRequest().setAttribute("org.globus.gsi.authorized.user.dn", (Object)globusID);
        }
        GSSContext context = socket.getContext();
        request.getRequest().setAttribute("org.globus.gsi.context", (Object)context);
    }
}

