/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceEnvRef;

public class ResourceEnvFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof ResourceEnvRef) {
            Reference reference = (Reference)object;
            ObjectFactory objectFactory = null;
            RefAddr refAddr = reference.get("factory");
            if (refAddr != null) {
                String string = refAddr.getContent().toString();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                if (classLoader != null) {
                    try {
                        clazz = classLoader.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz != null) {
                    try {
                        objectFactory = (ObjectFactory)clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (objectFactory != null) {
                return objectFactory.getObjectInstance(object, name, context, hashtable);
            }
            throw new NamingException("Cannot create resource instance");
        }
        return null;
    }
}

