/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.portlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.simple.Element;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import javax.portlet.WindowStateException;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;

public class PortletRequestUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletRequestUtil.class);

    public static List<DiskFileItem> testMultipartWithCommonsFileUpload(ActionRequest actionRequest) throws Exception {
        boolean multiPartContent = PortletFileUpload.isMultipartContent((ActionRequest)actionRequest);
        if (_log.isInfoEnabled()) {
            if (multiPartContent) {
                _log.info((Object)"The given request is a multipart request");
            } else {
                _log.info((Object)"The given request is NOT a multipart request");
            }
        }
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        PortletFileUpload portletFileUpload = new PortletFileUpload((FileItemFactory)diskFileItemFactory);
        List diskFileItems = portletFileUpload.parseRequest(actionRequest);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Apache commons upload was able to parse " + diskFileItems.size() + " items"));
        }
        int i = 0;
        while (i < diskFileItems.size()) {
            DiskFileItem diskFileItem = (DiskFileItem)diskFileItems.get(i);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Item " + i + " " + diskFileItem));
            }
            ++i;
        }
        return diskFileItems;
    }

    public static int testMultipartWithPortletInputStream(ActionRequest actionRequest) throws Exception {
        InputStream inputStream = actionRequest.getPortletInputStream();
        if (inputStream != null) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
            int size = unsyncByteArrayOutputStream.size();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Byte array size from the raw input stream is " + size));
            }
            return size;
        }
        return -1;
    }

    public static String toXML(PortletRequest portletRequest, PortletResponse portletResponse) {
        Element requestElement;
        block14: {
            ThemeDisplay themeDisplay;
            requestElement = new Element("request");
            requestElement.addElement("container-type", "portlet");
            requestElement.addElement("container-type", "portlet");
            requestElement.addElement("container-namespace", portletRequest.getContextPath());
            requestElement.addElement("content-type", portletRequest.getResponseContentType());
            requestElement.addElement("server-name", portletRequest.getServerName());
            requestElement.addElement("server-port", portletRequest.getServerPort());
            requestElement.addElement("secure", portletRequest.isSecure());
            requestElement.addElement("auth-type", portletRequest.getAuthType());
            requestElement.addElement("remote-user", portletRequest.getRemoteUser());
            requestElement.addElement("context-path", portletRequest.getContextPath());
            requestElement.addElement("locale", (Object)portletRequest.getLocale());
            requestElement.addElement("portlet-mode", (Object)portletRequest.getPortletMode());
            requestElement.addElement("portlet-session-id", portletRequest.getRequestedSessionId());
            requestElement.addElement("scheme", portletRequest.getScheme());
            requestElement.addElement("window-state", (Object)portletRequest.getWindowState());
            if (portletRequest instanceof ActionRequest) {
                requestElement.addElement("lifecycle", "ACTION_PHASE");
            } else if (portletRequest instanceof RenderRequest) {
                requestElement.addElement("lifecycle", "RENDER_PHASE");
            } else if (portletRequest instanceof ResourceRequest) {
                requestElement.addElement("lifecycle", "RESOURCE_PHASE");
            }
            if (portletResponse instanceof MimeResponse) {
                PortletRequestUtil._mimeResponseToXML((MimeResponse)portletResponse, requestElement);
            }
            if ((themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")) != null) {
                Element themeDisplayElement = requestElement.addElement("theme-display");
                PortletRequestUtil._themeDisplayToXML(themeDisplay, themeDisplayElement);
            }
            Element parametersElement = requestElement.addElement("parameters");
            Enumeration enu = portletRequest.getParameterNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                Element parameterElement = parametersElement.addElement("parameter");
                parameterElement.addElement("name", name);
                String[] values = portletRequest.getParameterValues(name);
                int i = 0;
                while (i < values.length) {
                    parameterElement.addElement("value", values[i]);
                    ++i;
                }
            }
            Element attributesElement = requestElement.addElement("attributes");
            enu = portletRequest.getAttributeNames();
            while (enu.hasMoreElements()) {
                Object value;
                String name = (String)enu.nextElement();
                if (!PortletRequestUtil._isValidAttributeName(name) || !PortletRequestUtil._isValidAttributeValue(value = portletRequest.getAttribute(name))) continue;
                Element attributeElement = attributesElement.addElement("attribute");
                attributeElement.addElement("name", name);
                attributeElement.addElement("value", value);
            }
            Element portletSessionElement = requestElement.addElement("portlet-session");
            attributesElement = portletSessionElement.addElement("portlet-attributes");
            PortletSession portletSession = portletRequest.getPortletSession();
            try {
                Element attributeElement;
                Object value;
                enu = portletSession.getAttributeNames(2);
                while (enu.hasMoreElements()) {
                    String name = (String)enu.nextElement();
                    if (!PortletRequestUtil._isValidAttributeName(name) || !PortletRequestUtil._isValidAttributeValue(value = portletSession.getAttribute(name, 2))) continue;
                    attributeElement = attributesElement.addElement("attribute");
                    attributeElement.addElement("name", name);
                    attributeElement.addElement("value", value);
                }
                attributesElement = portletSessionElement.addElement("application-attributes");
                enu = portletSession.getAttributeNames(1);
                while (enu.hasMoreElements()) {
                    String name = (String)enu.nextElement();
                    if (!PortletRequestUtil._isValidAttributeName(name) || !PortletRequestUtil._isValidAttributeValue(value = portletSession.getAttribute(name, 1))) continue;
                    attributeElement = attributesElement.addElement("attribute");
                    attributeElement.addElement("name", name);
                    attributeElement.addElement("value", value);
                }
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)ise.getMessage());
            }
        }
        return requestElement.toXMLString();
    }

    private static boolean _isValidAttributeName(String name) {
        return !StringUtil.equalsIgnoreCase((String)name, (String)"PORTLET_RENDER_PARAMETERS_") && !StringUtil.equalsIgnoreCase((String)name, (String)"j_password") && !StringUtil.equalsIgnoreCase((String)name, (String)"LAYOUT_CONTENT") && !StringUtil.equalsIgnoreCase((String)name, (String)"LAYOUTS") && !StringUtil.equalsIgnoreCase((String)name, (String)"USER_PASSWORD") && !name.startsWith("javax.") && !name.startsWith("liferay-ui:");
    }

    private static boolean _isValidAttributeValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            return col.size() != 0;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.size() != 0;
        }
        String objString = String.valueOf(obj);
        if (Validator.isNull((String)objString)) {
            return false;
        }
        String hashCode = "@".concat(StringUtil.toHexString((int)obj.hashCode()));
        return !objString.endsWith(hashCode);
    }

    private static void _mimeResponseToXML(MimeResponse mimeResponse, Element requestElement) {
        String namespace;
        block15: {
            block14: {
                namespace = mimeResponse.getNamespace();
                requestElement.addElement("portlet-namespace", namespace);
                try {
                    PortletURL actionURL = mimeResponse.createActionURL();
                    requestElement.addElement("action-url", (Object)actionURL);
                }
                catch (IllegalStateException ise) {
                    if (!_log.isWarnEnabled()) break block14;
                    _log.warn((Object)ise.getMessage());
                }
            }
            try {
                PortletURL renderURL = mimeResponse.createRenderURL();
                requestElement.addElement("render-url", (Object)renderURL);
                try {
                    renderURL.setWindowState(LiferayWindowState.EXCLUSIVE);
                    requestElement.addElement("render-url-exclusive", (Object)renderURL);
                }
                catch (WindowStateException windowStateException) {}
                try {
                    renderURL.setWindowState(LiferayWindowState.MAXIMIZED);
                    requestElement.addElement("render-url-maximized", (Object)renderURL);
                }
                catch (WindowStateException windowStateException) {}
                try {
                    renderURL.setWindowState(LiferayWindowState.MINIMIZED);
                    requestElement.addElement("render-url-minimized", (Object)renderURL);
                }
                catch (WindowStateException windowStateException) {}
                try {
                    renderURL.setWindowState(LiferayWindowState.NORMAL);
                    requestElement.addElement("render-url-normal", (Object)renderURL);
                }
                catch (WindowStateException windowStateException) {}
                try {
                    renderURL.setWindowState(LiferayWindowState.POP_UP);
                    requestElement.addElement("render-url-pop-up", (Object)renderURL);
                }
                catch (WindowStateException windowStateException) {}
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block15;
                _log.warn((Object)ise.getMessage());
            }
        }
        ResourceURL resourceURL = mimeResponse.createResourceURL();
        String resourceURLString = HttpUtil.removeParameter((String)resourceURL.toString(), (String)(String.valueOf(namespace) + "struts_action"));
        resourceURLString = HttpUtil.removeParameter((String)resourceURLString, (String)(String.valueOf(namespace) + "redirect"));
        requestElement.addElement("resource-url", resourceURLString);
    }

    private static void _portletDisplayToXML(PortletDisplay portletDisplay, Element portletDisplayElement) {
        portletDisplayElement.addElement("id", portletDisplay.getId());
        portletDisplayElement.addElement("instance-id", portletDisplay.getInstanceId());
        portletDisplayElement.addElement("portlet-name", portletDisplay.getPortletName());
        portletDisplayElement.addElement("resource-pk", portletDisplay.getResourcePK());
        portletDisplayElement.addElement("root-portlet-id", portletDisplay.getRootPortletId());
        portletDisplayElement.addElement("title", portletDisplay.getTitle());
    }

    private static void _themeDisplayToXML(ThemeDisplay themeDisplay, Element themeDisplayElement) {
        themeDisplayElement.addElement("cdn-host", themeDisplay.getCDNHost());
        themeDisplayElement.addElement("company-id", themeDisplay.getCompanyId());
        themeDisplayElement.addElement("do-as-user-id", themeDisplay.getDoAsUserId());
        themeDisplayElement.addElement("i18n-language-id", themeDisplay.getI18nLanguageId());
        themeDisplayElement.addElement("i18n-path", themeDisplay.getI18nPath());
        themeDisplayElement.addElement("language-id", themeDisplay.getLanguageId());
        themeDisplayElement.addElement("locale", (Object)themeDisplay.getLocale());
        themeDisplayElement.addElement("path-context", themeDisplay.getPathContext());
        themeDisplayElement.addElement("path-friendly-url-private-group", themeDisplay.getPathFriendlyURLPrivateGroup());
        themeDisplayElement.addElement("path-friendly-url-private-user", themeDisplay.getPathFriendlyURLPrivateUser());
        themeDisplayElement.addElement("path-friendly-url-public", themeDisplay.getPathFriendlyURLPublic());
        themeDisplayElement.addElement("path-image", themeDisplay.getPathImage());
        themeDisplayElement.addElement("path-main", themeDisplay.getPathMain());
        themeDisplayElement.addElement("path-theme-images", themeDisplay.getPathThemeImages());
        themeDisplayElement.addElement("plid", themeDisplay.getPlid());
        themeDisplayElement.addElement("portal-url", HttpUtil.removeProtocol((String)themeDisplay.getPortalURL()));
        themeDisplayElement.addElement("real-user-id", themeDisplay.getRealUserId());
        themeDisplayElement.addElement("scope-group-id", themeDisplay.getScopeGroupId());
        themeDisplayElement.addElement("secure", themeDisplay.isSecure());
        themeDisplayElement.addElement("server-name", themeDisplay.getServerName());
        themeDisplayElement.addElement("server-port", themeDisplay.getServerPort());
        themeDisplayElement.addElement("time-zone", themeDisplay.getTimeZone().getID());
        themeDisplayElement.addElement("url-portal", HttpUtil.removeProtocol((String)themeDisplay.getURLPortal()));
        themeDisplayElement.addElement("user-id", themeDisplay.getUserId());
        if (themeDisplay.getPortletDisplay() != null) {
            Element portletDisplayElement = themeDisplayElement.addElement("portlet-display");
            PortletRequestUtil._portletDisplayToXML(themeDisplay.getPortletDisplay(), portletDisplayElement);
        }
    }
}

