/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AllTests {
    public static final File TEST_POLICY = new File("etc/test.policy");

    public static Test suite() {
        TestSuite suite = new TestSuite("All tests");
        suite.addTest(org.freshcookies.security.policy.AllTests.suite());
        return suite;
    }

    public static void startSecurityManager() throws FileNotFoundException, MalformedURLException {
        AllTests.startSecurityManager(TEST_POLICY);
    }

    public static void startSecurityManager(final File policyFile) throws FileNotFoundException, MalformedURLException {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, FileNotFoundException {
                        File absoluteFile = policyFile.getAbsoluteFile();
                        if (!absoluteFile.exists()) {
                            throw new FileNotFoundException("Policy file " + policyFile.getAbsolutePath() + " does not exist.");
                        }
                        URL url = absoluteFile.toURL();
                        AllTests.setSecurityPolicy(url);
                        SecurityManager sm = new SecurityManager();
                        System.setSecurityManager(sm);
                        return null;
                    }
                }, null);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)e.getException();
                }
                if (!(e.getException() instanceof FileNotFoundException)) break block3;
                throw (FileNotFoundException)e.getException();
            }
        }
    }

    private static final void setSecurityPolicy(final URL url) throws SecurityException {
        if (url == null) {
            throw new SecurityException("URL for security policy cannot be null.");
        }
        String default_policy_class = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("policy.provider");
            }
        });
        if (default_policy_class == null) {
            default_policy_class = "sun.security.provider.PolicyFile";
        }
        final String policy_class = default_policy_class;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    System.setProperty("java.security.policy", url.toExternalForm());
                    Policy policy = (Policy)Class.forName(policy_class).newInstance();
                    Policy.setPolicy(policy);
                    return null;
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage());
                }
            }
        });
    }

    public static void stopSecurityManager() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setSecurityManager(null);
                return null;
            }
        }, null);
    }
}

