/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.HypergeometricDistribution;
import org.apache.commons.math.util.MathUtils;

public class HypergeometricDistributionImpl
extends AbstractIntegerDistribution
implements HypergeometricDistribution,
Serializable {
    private static final long serialVersionUID = -436928820673516179L;
    private int numberOfSuccesses;
    private int populationSize;
    private int sampleSize;

    public HypergeometricDistributionImpl(int populationSize, int numberOfSuccesses, int sampleSize) {
        if (numberOfSuccesses > populationSize) {
            throw MathRuntimeException.createIllegalArgumentException("number of successes ({0}) must be less than or equal to population size ({1})", numberOfSuccesses, populationSize);
        }
        if (sampleSize > populationSize) {
            throw MathRuntimeException.createIllegalArgumentException("sample size ({0}) must be less than or equal to population size ({1})", sampleSize, populationSize);
        }
        this.setPopulationSize(populationSize);
        this.setSampleSize(sampleSize);
        this.setNumberOfSuccesses(numberOfSuccesses);
    }

    public double cumulativeProbability(int x) {
        int k;
        int m;
        int n = this.getPopulationSize();
        int[] domain = this.getDomain(n, m = this.getNumberOfSuccesses(), k = this.getSampleSize());
        double ret = x < domain[0] ? 0.0 : (x >= domain[1] ? 1.0 : this.innerCumulativeProbability(domain[0], x, 1, n, m, k));
        return ret;
    }

    private int[] getDomain(int n, int m, int k) {
        return new int[]{this.getLowerDomain(n, m, k), this.getUpperDomain(m, k)};
    }

    protected int getDomainLowerBound(double p) {
        return this.getLowerDomain(this.getPopulationSize(), this.getNumberOfSuccesses(), this.getSampleSize());
    }

    protected int getDomainUpperBound(double p) {
        return this.getUpperDomain(this.getSampleSize(), this.getNumberOfSuccesses());
    }

    private int getLowerDomain(int n, int m, int k) {
        return Math.max(0, m - (n - k));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int m, int k) {
        return Math.min(k, m);
    }

    public double probability(int x) {
        int k;
        int m;
        int n = this.getPopulationSize();
        int[] domain = this.getDomain(n, m = this.getNumberOfSuccesses(), k = this.getSampleSize());
        double ret = x < domain[0] || x > domain[1] ? 0.0 : this.probability(n, m, k, x);
        return ret;
    }

    private double probability(int n, int m, int k, int x) {
        return Math.exp(MathUtils.binomialCoefficientLog(m, x) + MathUtils.binomialCoefficientLog(n - m, k - x) - MathUtils.binomialCoefficientLog(n, k));
    }

    public void setNumberOfSuccesses(int num) {
        if (num < 0) {
            throw MathRuntimeException.createIllegalArgumentException("number of successes must be non-negative ({0})", num);
        }
        this.numberOfSuccesses = num;
    }

    public void setPopulationSize(int size) {
        if (size <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("population size must be positive ({0})", size);
        }
        this.populationSize = size;
    }

    public void setSampleSize(int size) {
        if (size < 0) {
            throw MathRuntimeException.createIllegalArgumentException("sample size must be positive ({0})", size);
        }
        this.sampleSize = size;
    }

    public double upperCumulativeProbability(int x) {
        int k;
        int m;
        int n = this.getPopulationSize();
        int[] domain = this.getDomain(n, m = this.getNumberOfSuccesses(), k = this.getSampleSize());
        double ret = x < domain[0] ? 1.0 : (x > domain[1] ? 0.0 : this.innerCumulativeProbability(domain[1], x, -1, n, m, k));
        return ret;
    }

    private double innerCumulativeProbability(int x0, int x1, int dx, int n, int m, int k) {
        double ret = this.probability(n, m, k, x0);
        while (x0 != x1) {
            ret += this.probability(n, m, k, x0 += dx);
        }
        return ret;
    }
}

